/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class MessageSubscriptionRecord
extends UnifiedRecordValue
implements MessageSubscriptionRecordValue {
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty messageKeyProp = new LongProperty("messageKey", -1L);
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final BooleanProperty interruptingProp = new BooleanProperty("interrupting", true);
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public MessageSubscriptionRecord() {
        this.declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.elementInstanceKeyProp).declareProperty((BaseProperty)this.messageKeyProp).declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.interruptingProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public void wrap(MessageSubscriptionRecord record) {
        this.setProcessInstanceKey(record.getProcessInstanceKey());
        this.setElementInstanceKey(record.getElementInstanceKey());
        this.setMessageKey(record.getMessageKey());
        this.setMessageName(record.getMessageNameBuffer());
        this.setCorrelationKey(record.getCorrelationKeyBuffer());
        this.setInterrupting(record.isInterrupting());
        this.setBpmnProcessId(record.getBpmnProcessIdBuffer());
        this.setVariables(record.getVariablesBuffer());
        this.setTenantId(record.getTenantId());
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public MessageSubscriptionRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public String getMessageName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageNameProp.getValue());
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    public MessageSubscriptionRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    public boolean isInterrupting() {
        return this.interruptingProp.getValue();
    }

    public MessageSubscriptionRecord setInterrupting(boolean interrupting) {
        this.interruptingProp.setValue(interrupting);
        return this;
    }

    public MessageSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    public MessageSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public MessageSubscriptionRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public MessageSubscriptionRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public MessageSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public MessageSubscriptionRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

