/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.stream.job;

import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.msgpack.value.ValueArray;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JobActivationPropertiesImpl
extends UnpackedObject
implements JobActivationProperties {
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final LongProperty timeoutProp = new LongProperty("timeout", -1L);
    private final ArrayProperty<StringValue> fetchVariablesProp = new ArrayProperty("variables", (BaseValue)new StringValue());
    private final ArrayProperty<StringValue> tenantIdsProp = new ArrayProperty("tenantIds", (BaseValue)new StringValue("<default>"));

    public JobActivationPropertiesImpl() {
        this.declareProperty((BaseProperty)this.workerProp).declareProperty((BaseProperty)this.timeoutProp).declareProperty(this.fetchVariablesProp).declareProperty(this.tenantIdsProp);
    }

    public JobActivationPropertiesImpl setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }

    public JobActivationPropertiesImpl setTimeout(long val) {
        this.timeoutProp.setValue(val);
        return this;
    }

    public JobActivationPropertiesImpl setFetchVariables(List<StringValue> variables) {
        this.fetchVariablesProp.reset();
        variables.forEach(variable -> ((StringValue)this.fetchVariablesProp.add()).wrap(variable));
        return this;
    }

    @Override
    public DirectBuffer worker() {
        return this.workerProp.getValue();
    }

    @Override
    public Collection<DirectBuffer> fetchVariables() {
        return this.fetchVariablesProp.stream().map(val -> new UnsafeBuffer(val.getValue())).collect(Collectors.toList());
    }

    @Override
    public long timeout() {
        return this.timeoutProp.getValue();
    }

    @Override
    public List<String> getTenantIds() {
        return StreamSupport.stream(this.tenantIdsProp.spliterator(), false).map(StringValue::getValue).map(BufferUtil::bufferAsString).collect(Collectors.toList());
    }

    public JobActivationPropertiesImpl setTenantIds(List<String> tenantIds) {
        this.tenantIdsProp.reset();
        tenantIds.forEach(tenantId -> ((StringValue)this.tenantIdsProp.add()).wrap(BufferUtil.wrapString((String)tenantId)));
        return this;
    }

    public ValueArray<StringValue> tenantIds() {
        return this.tenantIdsProp;
    }
}

