/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.encoding;

import io.camunda.zeebe.protocol.management.AdminRequestDecoder;
import io.camunda.zeebe.protocol.management.AdminRequestEncoder;
import io.camunda.zeebe.protocol.management.AdminRequestType;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MessageHeaderEncoder;
import io.camunda.zeebe.util.buffer.BufferReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class AdminRequest
implements BufferReader,
BufferWriter {
    private final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    private final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    private final AdminRequestEncoder bodyEncoder = new AdminRequestEncoder();
    private final AdminRequestDecoder bodyDecoder = new AdminRequestDecoder();
    private int brokerId = AdminRequestEncoder.brokerIdNullValue();
    private int partitionId = AdminRequestEncoder.partitionIdNullValue();
    private AdminRequestType type = AdminRequestType.NULL_VAL;
    private long key = AdminRequestEncoder.keyNullValue();
    private byte[] payload = null;
    private boolean hasPayload = false;

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.bodyDecoder.wrapAndApplyHeader(buffer, offset, this.headerDecoder);
        this.brokerId = this.bodyDecoder.brokerId();
        this.partitionId = this.bodyDecoder.partitionId();
        this.type = this.bodyDecoder.type();
        this.bodyDecoder.getPayload(this.payload, 0, length - this.bodyDecoder.limit());
    }

    public int getLength() {
        return this.headerEncoder.encodedLength() + this.bodyEncoder.sbeBlockLength() + AdminRequestEncoder.payloadHeaderLength() + (this.hasPayload ? this.payload.length : 0);
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.bodyEncoder.wrapAndApplyHeader(buffer, offset, this.headerEncoder).brokerId(this.brokerId).partitionId(this.partitionId).type(this.type).key(this.key);
        if (this.hasPayload) {
            this.bodyEncoder.putPayload(this.payload, 0, this.payload.length);
        }
    }

    public int getBrokerId() {
        return this.brokerId;
    }

    public void setBrokerId(int brokerId) {
        this.brokerId = brokerId;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public void setPartitionId(int partitionId) {
        this.partitionId = partitionId;
    }

    public AdminRequestType getType() {
        return this.type;
    }

    public void setType(AdminRequestType type) {
        this.type = type;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public void setPayload(byte[] payload) {
        this.payload = payload;
        this.hasPayload = true;
    }
}

