/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.MessageStartEventSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class MessageStartEventSubscriptionRecord
extends UnifiedRecordValue
implements MessageStartEventSubscriptionRecordValue {
    private final LongProperty processDefinitionKeyProp = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final StringProperty startEventIdProp = new StringProperty("startEventId", "");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey", -1L);
    private final LongProperty messageKeyProp = new LongProperty("messageKey", -1L);
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public MessageStartEventSubscriptionRecord() {
        super(9);
        this.declareProperty((BaseProperty)this.processDefinitionKeyProp).declareProperty((BaseProperty)this.messageNameProp).declareProperty((BaseProperty)this.startEventIdProp).declareProperty((BaseProperty)this.bpmnProcessIdProp).declareProperty((BaseProperty)this.processInstanceKeyProp).declareProperty((BaseProperty)this.messageKeyProp).declareProperty((BaseProperty)this.correlationKeyProp).declareProperty((BaseProperty)this.variablesProp).declareProperty((BaseProperty)this.tenantIdProp);
    }

    public void wrap(MessageStartEventSubscriptionRecord record) {
        this.processDefinitionKeyProp.setValue(record.getProcessDefinitionKey());
        this.bpmnProcessIdProp.setValue(record.getBpmnProcessIdBuffer());
        this.messageNameProp.setValue(record.getMessageNameBuffer());
        this.startEventIdProp.setValue(record.getStartEventIdBuffer());
        this.processInstanceKeyProp.setValue(record.getProcessInstanceKey());
        this.messageKeyProp.setValue(record.getMessageKey());
        this.correlationKeyProp.setValue(record.getCorrelationKeyBuffer());
        this.variablesProp.setValue(record.getVariablesBuffer());
        this.tenantIdProp.setValue(record.getTenantId());
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getStartEventIdBuffer() {
        return this.startEventIdProp.getValue();
    }

    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProp.getValue();
    }

    public MessageStartEventSubscriptionRecord setProcessDefinitionKey(long key) {
        this.processDefinitionKeyProp.setValue(key);
        return this;
    }

    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.bpmnProcessIdProp.getValue());
    }

    public String getStartEventId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.startEventIdProp.getValue());
    }

    public String getMessageName() {
        return BufferUtil.bufferAsString((DirectBuffer)this.messageNameProp.getValue());
    }

    public MessageStartEventSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    public String getCorrelationKey() {
        return BufferUtil.bufferAsString((DirectBuffer)this.correlationKeyProp.getValue());
    }

    public MessageStartEventSubscriptionRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    public MessageStartEventSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    public MessageStartEventSubscriptionRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    public MessageStartEventSubscriptionRecord setStartEventId(DirectBuffer startEventId) {
        this.startEventIdProp.setValue(startEventId);
        return this;
    }

    public MessageStartEventSubscriptionRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public MessageStartEventSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    public String getTenantId() {
        return BufferUtil.bufferAsString((DirectBuffer)this.tenantIdProp.getValue());
    }

    public MessageStartEventSubscriptionRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

