package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvaluatedInputValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluatedInputValue.builder()}.
 */
@Generated(from = "EvaluatedInputValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableEvaluatedInputValue.Builder.class)
public final class ImmutableEvaluatedInputValue
    implements EvaluatedInputValue {
  private final String inputId;
  private final String inputName;
  private final String inputValue;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableEvaluatedInputValue(String inputId, String inputName, String inputValue) {
    this.inputId = inputId;
    this.inputName = inputName;
    this.inputValue = inputValue;
  }

  /**
   * @return the id of the evaluated input
   */
  @Override
  public String getInputId() {
    return inputId;
  }

  /**
   * @return the name of the evaluated input
   */
  @Override
  public String getInputName() {
    return inputName;
  }

  /**
   * @return the value of the evaluated input expression as JSON string
   */
  @Override
  public String getInputValue() {
    return inputValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedInputValue#getInputId() inputId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedInputValue withInputId(String value) {
    if (Objects.equals(this.inputId, value)) return this;
    return new ImmutableEvaluatedInputValue(value, this.inputName, this.inputValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedInputValue#getInputName() inputName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedInputValue withInputName(String value) {
    if (Objects.equals(this.inputName, value)) return this;
    return new ImmutableEvaluatedInputValue(this.inputId, value, this.inputValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedInputValue#getInputValue() inputValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for inputValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedInputValue withInputValue(String value) {
    if (Objects.equals(this.inputValue, value)) return this;
    return new ImmutableEvaluatedInputValue(this.inputId, this.inputName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluatedInputValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluatedInputValue
        && equalTo(0, (ImmutableEvaluatedInputValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluatedInputValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(inputId, another.inputId)
        && Objects.equals(inputName, another.inputName)
        && Objects.equals(inputValue, another.inputValue);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code inputId}, {@code inputName}, {@code inputValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(inputId);
    h += (h << 5) + Objects.hashCode(inputName);
    h += (h << 5) + Objects.hashCode(inputValue);
    return h;
  }

  /**
   * Prints the immutable value {@code EvaluatedInputValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvaluatedInputValue{"
        + "inputId=" + inputId
        + ", inputName=" + inputName
        + ", inputValue=" + inputValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EvaluatedInputValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvaluatedInputValue instance
   */
  public static ImmutableEvaluatedInputValue copyOf(EvaluatedInputValue instance) {
    if (instance instanceof ImmutableEvaluatedInputValue) {
      return (ImmutableEvaluatedInputValue) instance;
    }
    return ImmutableEvaluatedInputValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluatedInputValue ImmutableEvaluatedInputValue}.
   * <pre>
   * ImmutableEvaluatedInputValue.builder()
   *    .withInputId(String | null) // nullable {@link EvaluatedInputValue#getInputId() inputId}
   *    .withInputName(String | null) // nullable {@link EvaluatedInputValue#getInputName() inputName}
   *    .withInputValue(String | null) // nullable {@link EvaluatedInputValue#getInputValue() inputValue}
   *    .build();
   * </pre>
   * @return A new ImmutableEvaluatedInputValue builder
   */
  public static ImmutableEvaluatedInputValue.Builder builder() {
    return new ImmutableEvaluatedInputValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluatedInputValue ImmutableEvaluatedInputValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvaluatedInputValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String inputId;
    private @Nullable String inputName;
    private @Nullable String inputValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EvaluatedInputValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvaluatedInputValue instance) {
      Objects.requireNonNull(instance, "instance");
      String inputIdValue = instance.getInputId();
      if (inputIdValue != null) {
        withInputId(inputIdValue);
      }
      String inputNameValue = instance.getInputName();
      if (inputNameValue != null) {
        withInputName(inputNameValue);
      }
      String inputValueValue = instance.getInputValue();
      if (inputValueValue != null) {
        withInputValue(inputValueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedInputValue#getInputId() inputId} attribute.
     * @param inputId The value for inputId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withInputId(String inputId) {
      this.inputId = inputId;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedInputValue#getInputName() inputName} attribute.
     * @param inputName The value for inputName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withInputName(String inputName) {
      this.inputName = inputName;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedInputValue#getInputValue() inputValue} attribute.
     * @param inputValue The value for inputValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withInputValue(String inputValue) {
      this.inputValue = inputValue;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.inputId = null;
      this.inputName = null;
      this.inputValue = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluatedInputValue ImmutableEvaluatedInputValue}.
     * @return An immutable instance of EvaluatedInputValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluatedInputValue build() {
      return new ImmutableEvaluatedInputValue(inputId, inputName, inputValue);
    }



  }



}
