package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link EvaluatedOutputValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEvaluatedOutputValue.builder()}.
 */
@Generated(from = "EvaluatedOutputValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableEvaluatedOutputValue.Builder.class)
public final class ImmutableEvaluatedOutputValue
    implements EvaluatedOutputValue {
  private final String outputId;
  private final String outputName;
  private final String outputValue;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableEvaluatedOutputValue(String outputId, String outputName, String outputValue) {
    this.outputId = outputId;
    this.outputName = outputName;
    this.outputValue = outputValue;
  }

  /**
   * @return the id of the evaluated output
   */
  @Override
  public String getOutputId() {
    return outputId;
  }

  /**
   * @return the name of the evaluated output
   */
  @Override
  public String getOutputName() {
    return outputName;
  }

  /**
   * @return the value of the evaluated output expression as JSON string
   */
  @Override
  public String getOutputValue() {
    return outputValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedOutputValue#getOutputId() outputId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedOutputValue withOutputId(String value) {
    if (Objects.equals(this.outputId, value)) return this;
    return new ImmutableEvaluatedOutputValue(value, this.outputName, this.outputValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedOutputValue#getOutputName() outputName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedOutputValue withOutputName(String value) {
    if (Objects.equals(this.outputName, value)) return this;
    return new ImmutableEvaluatedOutputValue(this.outputId, value, this.outputValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EvaluatedOutputValue#getOutputValue() outputValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for outputValue (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableEvaluatedOutputValue withOutputValue(String value) {
    if (Objects.equals(this.outputValue, value)) return this;
    return new ImmutableEvaluatedOutputValue(this.outputId, this.outputName, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEvaluatedOutputValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEvaluatedOutputValue
        && equalTo(0, (ImmutableEvaluatedOutputValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableEvaluatedOutputValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(outputId, another.outputId)
        && Objects.equals(outputName, another.outputName)
        && Objects.equals(outputValue, another.outputValue);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code outputId}, {@code outputName}, {@code outputValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(outputId);
    h += (h << 5) + Objects.hashCode(outputName);
    h += (h << 5) + Objects.hashCode(outputValue);
    return h;
  }

  /**
   * Prints the immutable value {@code EvaluatedOutputValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EvaluatedOutputValue{"
        + "outputId=" + outputId
        + ", outputName=" + outputName
        + ", outputValue=" + outputValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EvaluatedOutputValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EvaluatedOutputValue instance
   */
  public static ImmutableEvaluatedOutputValue copyOf(EvaluatedOutputValue instance) {
    if (instance instanceof ImmutableEvaluatedOutputValue) {
      return (ImmutableEvaluatedOutputValue) instance;
    }
    return ImmutableEvaluatedOutputValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEvaluatedOutputValue ImmutableEvaluatedOutputValue}.
   * <pre>
   * ImmutableEvaluatedOutputValue.builder()
   *    .withOutputId(String | null) // nullable {@link EvaluatedOutputValue#getOutputId() outputId}
   *    .withOutputName(String | null) // nullable {@link EvaluatedOutputValue#getOutputName() outputName}
   *    .withOutputValue(String | null) // nullable {@link EvaluatedOutputValue#getOutputValue() outputValue}
   *    .build();
   * </pre>
   * @return A new ImmutableEvaluatedOutputValue builder
   */
  public static ImmutableEvaluatedOutputValue.Builder builder() {
    return new ImmutableEvaluatedOutputValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEvaluatedOutputValue ImmutableEvaluatedOutputValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "EvaluatedOutputValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String outputId;
    private @Nullable String outputName;
    private @Nullable String outputValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EvaluatedOutputValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EvaluatedOutputValue instance) {
      Objects.requireNonNull(instance, "instance");
      String outputIdValue = instance.getOutputId();
      if (outputIdValue != null) {
        withOutputId(outputIdValue);
      }
      String outputNameValue = instance.getOutputName();
      if (outputNameValue != null) {
        withOutputName(outputNameValue);
      }
      String outputValueValue = instance.getOutputValue();
      if (outputValueValue != null) {
        withOutputValue(outputValueValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedOutputValue#getOutputId() outputId} attribute.
     * @param outputId The value for outputId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOutputId(String outputId) {
      this.outputId = outputId;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedOutputValue#getOutputName() outputName} attribute.
     * @param outputName The value for outputName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOutputName(String outputName) {
      this.outputName = outputName;
      return this;
    }

    /**
     * Initializes the value for the {@link EvaluatedOutputValue#getOutputValue() outputValue} attribute.
     * @param outputValue The value for outputValue (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withOutputValue(String outputValue) {
      this.outputValue = outputValue;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.outputId = null;
      this.outputName = null;
      this.outputValue = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEvaluatedOutputValue ImmutableEvaluatedOutputValue}.
     * @return An immutable instance of EvaluatedOutputValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEvaluatedOutputValue build() {
      return new ImmutableEvaluatedOutputValue(outputId, outputName, outputValue);
    }



  }



}
