package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link JobRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableJobRecordValue.builder()}.
 */
@Generated(from = "JobRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableJobRecordValue.Builder.class)
public final class ImmutableJobRecordValue implements JobRecordValue {
  private final Map<String, Object> variables;
  private final long processInstanceKey;
  private final String type;
  private final Map<String, String> customHeaders;
  private final String worker;
  private final int retries;
  private final long retryBackoff;
  private final long recurringTime;
  private final long deadline;
  private final String errorMessage;
  private final String errorCode;
  private final String elementId;
  private final long elementInstanceKey;
  private final String bpmnProcessId;
  private final int processDefinitionVersion;
  private final long processDefinitionKey;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableJobRecordValue(
      Map<String, Object> variables,
      long processInstanceKey,
      String type,
      Map<String, String> customHeaders,
      String worker,
      int retries,
      long retryBackoff,
      long recurringTime,
      long deadline,
      String errorMessage,
      String errorCode,
      String elementId,
      long elementInstanceKey,
      String bpmnProcessId,
      int processDefinitionVersion,
      long processDefinitionKey) {
    this.variables = variables;
    this.processInstanceKey = processInstanceKey;
    this.type = type;
    this.customHeaders = customHeaders;
    this.worker = worker;
    this.retries = retries;
    this.retryBackoff = retryBackoff;
    this.recurringTime = recurringTime;
    this.deadline = deadline;
    this.errorMessage = errorMessage;
    this.errorCode = errorCode;
    this.elementId = elementId;
    this.elementInstanceKey = elementInstanceKey;
    this.bpmnProcessId = bpmnProcessId;
    this.processDefinitionVersion = processDefinitionVersion;
    this.processDefinitionKey = processDefinitionKey;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the type of the job
   */
  @Override
  public String getType() {
    return type;
  }

  /**
   * @return user-defined headers associated with this job
   */
  @Override
  public Map<String, String> getCustomHeaders() {
    return customHeaders;
  }

  /**
   * @return the assigned worker to complete the job
   */
  @Override
  public String getWorker() {
    return worker;
  }

  /**
   * @return remaining retries
   */
  @Override
  public int getRetries() {
    return retries;
  }

  /**
   * @return the time of backoff in milliseconds. If backoff is disabled this method returns 0
   *     (default value).
   */
  @Override
  public long getRetryBackoff() {
    return retryBackoff;
  }

  /**
   * @return the timestamp when this job record should be recurred. This method is used by backoff
   *     to determine the date when the job is needed to be recurred after backoff.
   */
  @Override
  public long getRecurringTime() {
    return recurringTime;
  }

  /**
   * @return the unix timestamp until when the job is exclusively assigned to this worker (time unit
   *     is milliseconds since unix epoch). If the deadline is exceeded, it can happen that the job
   *     is handed to another worker and the work is performed twice. If this property is not set it
   *     will return '-1'.
   */
  @Override
  public long getDeadline() {
    return deadline;
  }

  /**
   * @return the message that contains additional context of the failure/error. It is set by the job
   *     worker then the processing fails because of a technical failure or a non-technical error.
   */
  @Override
  public String getErrorMessage() {
    return errorMessage;
  }

  /**
   * @return the error code to identify the business error. It is set by the job worker then the
   *     processing fails because of a non-technical error that should be handled by the process.
   */
  @Override
  public String getErrorCode() {
    return errorCode;
  }

  /**
   * @return the element id of the corresponding service task
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * @return the element instance key of the corresponding service task
   */
  @Override
  public long getElementInstanceKey() {
    return elementInstanceKey;
  }

  /**
   * @return the bpmn process id of the corresponding process definition
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of the corresponding process definition
   */
  @Override
  public int getProcessDefinitionVersion() {
    return processDefinitionVersion;
  }

  /**
   * @return the process key of the corresponding process definition
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * Copy the current immutable object by replacing the {@link JobRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableJobRecordValue(
        newValue,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        value,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withType(String value) {
    if (Objects.equals(this.type, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        value,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by replacing the {@link JobRecordValue#getCustomHeaders() customHeaders} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the customHeaders map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableJobRecordValue withCustomHeaders(Map<String, ? extends String> entries) {
    if (this.customHeaders == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        newValue,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getWorker() worker} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for worker (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withWorker(String value) {
    if (Objects.equals(this.worker, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        value,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getRetries() retries} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for retries
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withRetries(int value) {
    if (this.retries == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        value,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getRetryBackoff() retryBackoff} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for retryBackoff
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withRetryBackoff(long value) {
    if (this.retryBackoff == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        value,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getRecurringTime() recurringTime} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for recurringTime
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withRecurringTime(long value) {
    if (this.recurringTime == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        value,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getDeadline() deadline} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for deadline
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withDeadline(long value) {
    if (this.deadline == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        value,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getErrorMessage() errorMessage} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorMessage (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withErrorMessage(String value) {
    if (Objects.equals(this.errorMessage, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        value,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getErrorCode() errorCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for errorCode (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withErrorCode(String value) {
    if (Objects.equals(this.errorCode, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        value,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        value,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withElementInstanceKey(long value) {
    if (this.elementInstanceKey == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        value,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        value,
        this.processDefinitionVersion,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withProcessDefinitionVersion(int value) {
    if (this.processDefinitionVersion == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        value,
        this.processDefinitionKey);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link JobRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableJobRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableJobRecordValue(
        this.variables,
        this.processInstanceKey,
        this.type,
        this.customHeaders,
        this.worker,
        this.retries,
        this.retryBackoff,
        this.recurringTime,
        this.deadline,
        this.errorMessage,
        this.errorCode,
        this.elementId,
        this.elementInstanceKey,
        this.bpmnProcessId,
        this.processDefinitionVersion,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableJobRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableJobRecordValue
        && equalTo(0, (ImmutableJobRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableJobRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && processInstanceKey == another.processInstanceKey
        && Objects.equals(type, another.type)
        && customHeaders.equals(another.customHeaders)
        && Objects.equals(worker, another.worker)
        && retries == another.retries
        && retryBackoff == another.retryBackoff
        && recurringTime == another.recurringTime
        && deadline == another.deadline
        && Objects.equals(errorMessage, another.errorMessage)
        && Objects.equals(errorCode, another.errorCode)
        && Objects.equals(elementId, another.elementId)
        && elementInstanceKey == another.elementInstanceKey
        && Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && processDefinitionVersion == another.processDefinitionVersion
        && processDefinitionKey == another.processDefinitionKey;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code processInstanceKey}, {@code type}, {@code customHeaders}, {@code worker}, {@code retries}, {@code retryBackoff}, {@code recurringTime}, {@code deadline}, {@code errorMessage}, {@code errorCode}, {@code elementId}, {@code elementInstanceKey}, {@code bpmnProcessId}, {@code processDefinitionVersion}, {@code processDefinitionKey}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Objects.hashCode(type);
    h += (h << 5) + customHeaders.hashCode();
    h += (h << 5) + Objects.hashCode(worker);
    h += (h << 5) + retries;
    h += (h << 5) + Long.hashCode(retryBackoff);
    h += (h << 5) + Long.hashCode(recurringTime);
    h += (h << 5) + Long.hashCode(deadline);
    h += (h << 5) + Objects.hashCode(errorMessage);
    h += (h << 5) + Objects.hashCode(errorCode);
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(elementInstanceKey);
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + processDefinitionVersion;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    return h;
  }

  /**
   * Prints the immutable value {@code JobRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "JobRecordValue{"
        + "variables=" + variables
        + ", processInstanceKey=" + processInstanceKey
        + ", type=" + type
        + ", customHeaders=" + customHeaders
        + ", worker=" + worker
        + ", retries=" + retries
        + ", retryBackoff=" + retryBackoff
        + ", recurringTime=" + recurringTime
        + ", deadline=" + deadline
        + ", errorMessage=" + errorMessage
        + ", errorCode=" + errorCode
        + ", elementId=" + elementId
        + ", elementInstanceKey=" + elementInstanceKey
        + ", bpmnProcessId=" + bpmnProcessId
        + ", processDefinitionVersion=" + processDefinitionVersion
        + ", processDefinitionKey=" + processDefinitionKey
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link JobRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable JobRecordValue instance
   */
  public static ImmutableJobRecordValue copyOf(JobRecordValue instance) {
    if (instance instanceof ImmutableJobRecordValue) {
      return (ImmutableJobRecordValue) instance;
    }
    return ImmutableJobRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableJobRecordValue ImmutableJobRecordValue}.
   * <pre>
   * ImmutableJobRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link JobRecordValue#getVariables() variables} mappings
   *    .withProcessInstanceKey(long) // optional {@link JobRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withType(String | null) // nullable {@link JobRecordValue#getType() type}
   *    .putCustomHeader|putAllCustomHeaders(String =&gt; String) // {@link JobRecordValue#getCustomHeaders() customHeaders} mappings
   *    .withWorker(String | null) // nullable {@link JobRecordValue#getWorker() worker}
   *    .withRetries(int) // optional {@link JobRecordValue#getRetries() retries}
   *    .withRetryBackoff(long) // optional {@link JobRecordValue#getRetryBackoff() retryBackoff}
   *    .withRecurringTime(long) // optional {@link JobRecordValue#getRecurringTime() recurringTime}
   *    .withDeadline(long) // optional {@link JobRecordValue#getDeadline() deadline}
   *    .withErrorMessage(String | null) // nullable {@link JobRecordValue#getErrorMessage() errorMessage}
   *    .withErrorCode(String | null) // nullable {@link JobRecordValue#getErrorCode() errorCode}
   *    .withElementId(String | null) // nullable {@link JobRecordValue#getElementId() elementId}
   *    .withElementInstanceKey(long) // optional {@link JobRecordValue#getElementInstanceKey() elementInstanceKey}
   *    .withBpmnProcessId(String | null) // nullable {@link JobRecordValue#getBpmnProcessId() bpmnProcessId}
   *    .withProcessDefinitionVersion(int) // optional {@link JobRecordValue#getProcessDefinitionVersion() processDefinitionVersion}
   *    .withProcessDefinitionKey(long) // optional {@link JobRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .build();
   * </pre>
   * @return A new ImmutableJobRecordValue builder
   */
  public static ImmutableJobRecordValue.Builder builder() {
    return new ImmutableJobRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableJobRecordValue ImmutableJobRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "JobRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private long processInstanceKey;
    private @Nullable String type;
    private Map<String, String> customHeaders = new LinkedHashMap<String, String>();
    private @Nullable String worker;
    private int retries;
    private long retryBackoff;
    private long recurringTime;
    private long deadline;
    private @Nullable String errorMessage;
    private @Nullable String errorCode;
    private @Nullable String elementId;
    private long elementInstanceKey;
    private @Nullable String bpmnProcessId;
    private int processDefinitionVersion;
    private long processDefinitionKey;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.JobRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(JobRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof JobRecordValue) {
        JobRecordValue instance = (JobRecordValue) object;
        String elementIdValue = instance.getElementId();
        if (elementIdValue != null) {
          withElementId(elementIdValue);
        }
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
        String errorMessageValue = instance.getErrorMessage();
        if (errorMessageValue != null) {
          withErrorMessage(errorMessageValue);
        }
        String errorCodeValue = instance.getErrorCode();
        if (errorCodeValue != null) {
          withErrorCode(errorCodeValue);
        }
        withRetryBackoff(instance.getRetryBackoff());
        String typeValue = instance.getType();
        if (typeValue != null) {
          withType(typeValue);
        }
        withRecurringTime(instance.getRecurringTime());
        withProcessDefinitionKey(instance.getProcessDefinitionKey());
        withRetries(instance.getRetries());
        withElementInstanceKey(instance.getElementInstanceKey());
        String bpmnProcessIdValue = instance.getBpmnProcessId();
        if (bpmnProcessIdValue != null) {
          withBpmnProcessId(bpmnProcessIdValue);
        }
        String workerValue = instance.getWorker();
        if (workerValue != null) {
          withWorker(workerValue);
        }
        withDeadline(instance.getDeadline());
        putAllCustomHeaders(instance.getCustomHeaders());
        withProcessDefinitionVersion(instance.getProcessDefinitionVersion());
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x2L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Put one entry to the {@link JobRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(@Nullable String key, @Nullable Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link JobRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JobRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JobRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withType(String type) {
      this.type = type;
      return this;
    }

    /**
     * Put one entry to the {@link JobRecordValue#getCustomHeaders() customHeaders} map.
     * @param key The key in the customHeaders map
     * @param value The associated value in the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomHeader(@Nullable String key, @Nullable String value) {
      this.customHeaders.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link JobRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putCustomHeader(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.customHeaders.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link JobRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCustomHeaders(Map<String, ? extends String> entries) {
      this.customHeaders.clear();
      return putAllCustomHeaders(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link JobRecordValue#getCustomHeaders() customHeaders} map. Nulls are not permitted
     * @param entries The entries that will be added to the customHeaders map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllCustomHeaders(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.customHeaders.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getWorker() worker} attribute.
     * @param worker The value for worker (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withWorker(String worker) {
      this.worker = worker;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getRetries() retries} attribute.
     * @param retries The value for retries 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRetries(int retries) {
      this.retries = retries;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getRetryBackoff() retryBackoff} attribute.
     * @param retryBackoff The value for retryBackoff 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRetryBackoff(long retryBackoff) {
      this.retryBackoff = retryBackoff;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getRecurringTime() recurringTime} attribute.
     * @param recurringTime The value for recurringTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withRecurringTime(long recurringTime) {
      this.recurringTime = recurringTime;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getDeadline() deadline} attribute.
     * @param deadline The value for deadline 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDeadline(long deadline) {
      this.deadline = deadline;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getErrorMessage() errorMessage} attribute.
     * @param errorMessage The value for errorMessage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withErrorMessage(String errorMessage) {
      this.errorMessage = errorMessage;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getErrorCode() errorCode} attribute.
     * @param errorCode The value for errorCode (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withErrorCode(String errorCode) {
      this.errorCode = errorCode;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getElementInstanceKey() elementInstanceKey} attribute.
     * @param elementInstanceKey The value for elementInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementInstanceKey(long elementInstanceKey) {
      this.elementInstanceKey = elementInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getProcessDefinitionVersion() processDefinitionVersion} attribute.
     * @param processDefinitionVersion The value for processDefinitionVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionVersion(int processDefinitionVersion) {
      this.processDefinitionVersion = processDefinitionVersion;
      return this;
    }

    /**
     * Initializes the value for the {@link JobRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.processInstanceKey = 0;
      this.type = null;
      this.customHeaders.clear();
      this.worker = null;
      this.retries = 0;
      this.retryBackoff = 0;
      this.recurringTime = 0;
      this.deadline = 0;
      this.errorMessage = null;
      this.errorCode = null;
      this.elementId = null;
      this.elementInstanceKey = 0;
      this.bpmnProcessId = null;
      this.processDefinitionVersion = 0;
      this.processDefinitionKey = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableJobRecordValue ImmutableJobRecordValue}.
     * @return An immutable instance of JobRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableJobRecordValue build() {
      return new ImmutableJobRecordValue(
          createUnmodifiableMap(false, false, variables),
          processInstanceKey,
          type,
          createUnmodifiableMap(false, false, customHeaders),
          worker,
          retries,
          retryBackoff,
          recurringTime,
          deadline,
          errorMessage,
          errorCode,
          elementId,
          elementInstanceKey,
          bpmnProcessId,
          processDefinitionVersion,
          processDefinitionKey);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
