package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link SignalRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableSignalRecordValue.builder()}.
 */
@Generated(from = "SignalRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableSignalRecordValue.Builder.class)
public final class ImmutableSignalRecordValue
    implements SignalRecordValue {
  private final Map<String, Object> variables;
  private final String signalName;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableSignalRecordValue(Map<String, Object> variables, String signalName) {
    this.variables = variables;
    this.signalName = signalName;
  }

  /**
   * @return the variables of this record. Can be empty.
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * @return the name of the signal
   */
  @Override
  public String getSignalName() {
    return signalName;
  }

  /**
   * Copy the current immutable object by replacing the {@link SignalRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableSignalRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableSignalRecordValue(newValue, this.signalName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SignalRecordValue#getSignalName() signalName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for signalName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableSignalRecordValue withSignalName(String value) {
    if (Objects.equals(this.signalName, value)) return this;
    return new ImmutableSignalRecordValue(this.variables, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableSignalRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableSignalRecordValue
        && equalTo(0, (ImmutableSignalRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableSignalRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return variables.equals(another.variables)
        && Objects.equals(signalName, another.signalName);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code variables}, {@code signalName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + variables.hashCode();
    h += (h << 5) + Objects.hashCode(signalName);
    return h;
  }

  /**
   * Prints the immutable value {@code SignalRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SignalRecordValue{"
        + "variables=" + variables
        + ", signalName=" + signalName
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link SignalRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SignalRecordValue instance
   */
  public static ImmutableSignalRecordValue copyOf(SignalRecordValue instance) {
    if (instance instanceof ImmutableSignalRecordValue) {
      return (ImmutableSignalRecordValue) instance;
    }
    return ImmutableSignalRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableSignalRecordValue ImmutableSignalRecordValue}.
   * <pre>
   * ImmutableSignalRecordValue.builder()
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link SignalRecordValue#getVariables() variables} mappings
   *    .withSignalName(String | null) // nullable {@link SignalRecordValue#getSignalName() signalName}
   *    .build();
   * </pre>
   * @return A new ImmutableSignalRecordValue builder
   */
  public static ImmutableSignalRecordValue.Builder builder() {
    return new ImmutableSignalRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableSignalRecordValue ImmutableSignalRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "SignalRecordValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();
    private @Nullable String signalName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.SignalRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SignalRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.RecordValueWithVariables} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(RecordValueWithVariables instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SignalRecordValue) {
        SignalRecordValue instance = (SignalRecordValue) object;
        String signalNameValue = instance.getSignalName();
        if (signalNameValue != null) {
          withSignalName(signalNameValue);
        }
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
      }
      if (object instanceof RecordValueWithVariables) {
        RecordValueWithVariables instance = (RecordValueWithVariables) object;
        if ((bits & 0x1L) == 0) {
          putAllVariables(instance.getVariables());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Put one entry to the {@link SignalRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(@Nullable String key, @Nullable Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link SignalRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link SignalRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link SignalRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SignalRecordValue#getSignalName() signalName} attribute.
     * @param signalName The value for signalName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withSignalName(String signalName) {
      this.signalName = signalName;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.variables.clear();
      this.signalName = null;
      return this;
    }

    /**
     * Builds a new {@link ImmutableSignalRecordValue ImmutableSignalRecordValue}.
     * @return An immutable instance of SignalRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableSignalRecordValue build() {
      return new ImmutableSignalRecordValue(createUnmodifiableMap(false, false, variables), signalName);
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        if (v == null) Objects.requireNonNull(v, "value for key: " + k);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            if (v == null) Objects.requireNonNull(v, "value for key: " + k);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
