package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessMetadataValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessMetadataValue.builder()}.
 */
@Generated(from = "ProcessMetadataValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Immutable
@ImmutableProtocol.Type(builder=ImmutableProcessMetadataValue.Builder.class)
public final class ImmutableProcessMetadataValue
    implements ProcessMetadataValue {
  private final String bpmnProcessId;
  private final int version;
  private final long processDefinitionKey;
  private final String resourceName;
  private final byte[] checksum;
  private final boolean duplicate;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessMetadataValue(
      String bpmnProcessId,
      int version,
      long processDefinitionKey,
      String resourceName,
      byte[] checksum,
      boolean duplicate) {
    this.bpmnProcessId = bpmnProcessId;
    this.version = version;
    this.processDefinitionKey = processDefinitionKey;
    this.resourceName = resourceName;
    this.checksum = checksum;
    this.duplicate = duplicate;
  }

  /**
   * @return the bpmn process ID of this process
   */
  @Override
  public String getBpmnProcessId() {
    return bpmnProcessId;
  }

  /**
   * @return the version of this process
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the key of this process
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the name of the resource through which this process was deployed
   */
  @Override
  public String getResourceName() {
    return resourceName;
  }

  /**
   * @return the checksum of the process (MD5)
   */
  @Override
  public byte[] getChecksum() {
    return checksum;
  }

  /**
   * return true if the process is a duplicate (and has been deployed previously), false otherwise
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bpmnProcessId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withBpmnProcessId(String value) {
    if (Objects.equals(this.bpmnProcessId, value)) return this;
    return new ImmutableProcessMetadataValue(
        value,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableProcessMetadataValue(
        this.bpmnProcessId,
        value,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableProcessMetadataValue(this.bpmnProcessId, this.version, value, this.resourceName, this.checksum, this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#getResourceName() resourceName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for resourceName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withResourceName(String value) {
    if (Objects.equals(this.resourceName, value)) return this;
    return new ImmutableProcessMetadataValue(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        value,
        this.checksum,
        this.duplicate);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessMetadataValue#getChecksum() checksum}.
   * The array is cloned before being saved as attribute values.
   * @param elements The non-null elements for checksum
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessMetadataValue withChecksum(byte... elements) {
    byte[] newValue = elements == null ? null : elements.clone();
    return new ImmutableProcessMetadataValue(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        newValue,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessMetadataValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessMetadataValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableProcessMetadataValue(
        this.bpmnProcessId,
        this.version,
        this.processDefinitionKey,
        this.resourceName,
        this.checksum,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessMetadataValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessMetadataValue
        && equalTo(0, (ImmutableProcessMetadataValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessMetadataValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(bpmnProcessId, another.bpmnProcessId)
        && version == another.version
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(resourceName, another.resourceName)
        && Arrays.equals(checksum, another.checksum)
        && duplicate == another.duplicate;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code bpmnProcessId}, {@code version}, {@code processDefinitionKey}, {@code resourceName}, {@code checksum}, {@code duplicate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(bpmnProcessId);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(resourceName);
    h += (h << 5) + Arrays.hashCode(checksum);
    h += (h << 5) + Boolean.hashCode(duplicate);
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessMetadataValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessMetadataValue{"
        + "bpmnProcessId=" + bpmnProcessId
        + ", version=" + version
        + ", processDefinitionKey=" + processDefinitionKey
        + ", resourceName=" + resourceName
        + ", checksum=" + Arrays.toString(checksum)
        + ", duplicate=" + duplicate
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessMetadataValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessMetadataValue instance
   */
  public static ImmutableProcessMetadataValue copyOf(ProcessMetadataValue instance) {
    if (instance instanceof ImmutableProcessMetadataValue) {
      return (ImmutableProcessMetadataValue) instance;
    }
    return ImmutableProcessMetadataValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
   * <pre>
   * ImmutableProcessMetadataValue.builder()
   *    .withBpmnProcessId(String | null) // nullable {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId}
   *    .withVersion(int) // optional {@link ProcessMetadataValue#getVersion() version}
   *    .withProcessDefinitionKey(long) // optional {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withResourceName(String | null) // nullable {@link ProcessMetadataValue#getResourceName() resourceName}
   *    .withChecksum(byte[] | null) // nullable {@link ProcessMetadataValue#getChecksum() checksum}
   *    .withDuplicate(boolean) // optional {@link ProcessMetadataValue#isDuplicate() duplicate}
   *    .build();
   * </pre>
   * @return A new ImmutableProcessMetadataValue builder
   */
  public static ImmutableProcessMetadataValue.Builder builder() {
    return new ImmutableProcessMetadataValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessMetadataValue", generator = "Immutables")
  @NotThreadSafe
  @ImmutableProtocol.Builder
  public static final class Builder {
    private @Nullable String bpmnProcessId;
    private int version;
    private long processDefinitionKey;
    private @Nullable String resourceName;
    private @Nullable byte[] checksum;
    private boolean duplicate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessMetadataValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessMetadataValue instance) {
      Objects.requireNonNull(instance, "instance");
      String bpmnProcessIdValue = instance.getBpmnProcessId();
      if (bpmnProcessIdValue != null) {
        withBpmnProcessId(bpmnProcessIdValue);
      }
      withVersion(instance.getVersion());
      withProcessDefinitionKey(instance.getProcessDefinitionKey());
      String resourceNameValue = instance.getResourceName();
      if (resourceNameValue != null) {
        withResourceName(resourceNameValue);
      }
      byte[] checksumValue = instance.getChecksum();
      if (checksumValue != null) {
        withChecksum(checksumValue);
      }
      withDuplicate(instance.isDuplicate());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getBpmnProcessId() bpmnProcessId} attribute.
     * @param bpmnProcessId The value for bpmnProcessId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withBpmnProcessId(String bpmnProcessId) {
      this.bpmnProcessId = bpmnProcessId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getResourceName() resourceName} attribute.
     * @param resourceName The value for resourceName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withResourceName(String resourceName) {
      this.resourceName = resourceName;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#getChecksum() checksum} attribute.
     * @param checksum The elements for checksum
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withChecksum(byte... checksum) {
      this.checksum = checksum;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessMetadataValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.bpmnProcessId = null;
      this.version = 0;
      this.processDefinitionKey = 0;
      this.resourceName = null;
      this.checksum = null;
      this.duplicate = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessMetadataValue ImmutableProcessMetadataValue}.
     * @return An immutable instance of ProcessMetadataValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessMetadataValue build() {
      return new ImmutableProcessMetadataValue(bpmnProcessId, version, processDefinitionKey, resourceName, checksum, duplicate);
    }



  }



}
