package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DeploymentDistributionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDeploymentDistributionRecordValue.builder()}.
 */
@Generated(from = "DeploymentDistributionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@Deprecated
@ImmutableProtocol.Type(builder=ImmutableDeploymentDistributionRecordValue.Builder.class)
public final class ImmutableDeploymentDistributionRecordValue
    implements DeploymentDistributionRecordValue {
  private final int partitionId;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDeploymentDistributionRecordValue(int partitionId) {
    this.partitionId = partitionId;
  }

  /**
   * @return the partition where the deployment should be distributed
   */
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DeploymentDistributionRecordValue#getPartitionId() partitionId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for partitionId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDeploymentDistributionRecordValue withPartitionId(int value) {
    if (this.partitionId == value) return this;
    return new ImmutableDeploymentDistributionRecordValue(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDeploymentDistributionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDeploymentDistributionRecordValue
        && equalTo(0, (ImmutableDeploymentDistributionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDeploymentDistributionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return partitionId == another.partitionId;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code partitionId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + partitionId;
    return h;
  }

  /**
   * Prints the immutable value {@code DeploymentDistributionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DeploymentDistributionRecordValue{"
        + "partitionId=" + partitionId
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DeploymentDistributionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DeploymentDistributionRecordValue instance
   */
  public static ImmutableDeploymentDistributionRecordValue copyOf(DeploymentDistributionRecordValue instance) {
    if (instance instanceof ImmutableDeploymentDistributionRecordValue) {
      return (ImmutableDeploymentDistributionRecordValue) instance;
    }
    return ImmutableDeploymentDistributionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDeploymentDistributionRecordValue ImmutableDeploymentDistributionRecordValue}.
   * <pre>
   * ImmutableDeploymentDistributionRecordValue.builder()
   *    .withPartitionId(int) // optional {@link DeploymentDistributionRecordValue#getPartitionId() partitionId}
   *    .build();
   * </pre>
   * @return A new ImmutableDeploymentDistributionRecordValue builder
   */
  public static ImmutableDeploymentDistributionRecordValue.Builder builder() {
    return new ImmutableDeploymentDistributionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDeploymentDistributionRecordValue ImmutableDeploymentDistributionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DeploymentDistributionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private int partitionId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DeploymentDistributionRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DeploymentDistributionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      withPartitionId(instance.getPartitionId());
      return this;
    }

    /**
     * Initializes the value for the {@link DeploymentDistributionRecordValue#getPartitionId() partitionId} attribute.
     * @param partitionId The value for partitionId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.partitionId = 0;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDeploymentDistributionRecordValue ImmutableDeploymentDistributionRecordValue}.
     * @return An immutable instance of DeploymentDistributionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDeploymentDistributionRecordValue build() {
      return new ImmutableDeploymentDistributionRecordValue(partitionId);
    }



  }



}
