package io.camunda.zeebe.protocol.record.value.deployment;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link DecisionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableDecisionRecordValue.builder()}.
 */
@Generated(from = "DecisionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableDecisionRecordValue.Builder.class)
public final class ImmutableDecisionRecordValue
    implements DecisionRecordValue {
  private final String tenantId;
  private final String decisionId;
  private final String decisionName;
  private final int version;
  private final long decisionKey;
  private final String decisionRequirementsId;
  private final long decisionRequirementsKey;
  private final boolean duplicate;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableDecisionRecordValue(
      String tenantId,
      String decisionId,
      String decisionName,
      int version,
      long decisionKey,
      String decisionRequirementsId,
      long decisionRequirementsKey,
      boolean duplicate) {
    this.tenantId = tenantId;
    this.decisionId = decisionId;
    this.decisionName = decisionName;
    this.version = version;
    this.decisionKey = decisionKey;
    this.decisionRequirementsId = decisionRequirementsId;
    this.decisionRequirementsKey = decisionRequirementsKey;
    this.duplicate = duplicate;
  }

  /**
   *Returns the identifier of the tenant that owns this entity. 
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the ID of the decision in the DMN
   */
  @Override
  public String getDecisionId() {
    return decisionId;
  }

  /**
   * @return the name of the decision in the DMN
   */
  @Override
  public String getDecisionName() {
    return decisionName;
  }

  /**
   * @return the version of the deployed decision
   */
  @Override
  public int getVersion() {
    return version;
  }

  /**
   * @return the key of the deployed decision
   */
  @Override
  public long getDecisionKey() {
    return decisionKey;
  }

  /**
   * @return the ID of the DRG in the DMN this decision belongs to
   */
  @Override
  public String getDecisionRequirementsId() {
    return decisionRequirementsId;
  }

  /**
   * @return the key of the deployed DRG this decision belongs to
   */
  @Override
  public long getDecisionRequirementsKey() {
    return decisionRequirementsKey;
  }

  /**
   * @return {@code true} if the decision is a duplicate (and has been deployed previously),
   *     otherwise {@code false}
   */
  @Override
  public boolean isDuplicate() {
    return duplicate;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableDecisionRecordValue(
        value,
        this.decisionId,
        this.decisionName,
        this.version,
        this.decisionKey,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getDecisionId() decisionId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDecisionId(String value) {
    if (Objects.equals(this.decisionId, value)) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        value,
        this.decisionName,
        this.version,
        this.decisionKey,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getDecisionName() decisionName} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionName (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDecisionName(String value) {
    if (Objects.equals(this.decisionName, value)) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        value,
        this.version,
        this.decisionKey,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getVersion() version} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withVersion(int value) {
    if (this.version == value) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        this.decisionName,
        value,
        this.decisionKey,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getDecisionKey() decisionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDecisionKey(long value) {
    if (this.decisionKey == value) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        this.decisionName,
        this.version,
        value,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDecisionRequirementsId(String value) {
    if (Objects.equals(this.decisionRequirementsId, value)) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        this.decisionName,
        this.version,
        this.decisionKey,
        value,
        this.decisionRequirementsKey,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for decisionRequirementsKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDecisionRequirementsKey(long value) {
    if (this.decisionRequirementsKey == value) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        this.decisionName,
        this.version,
        this.decisionKey,
        this.decisionRequirementsId,
        value,
        this.duplicate);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link DecisionRecordValue#isDuplicate() duplicate} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for duplicate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableDecisionRecordValue withDuplicate(boolean value) {
    if (this.duplicate == value) return this;
    return new ImmutableDecisionRecordValue(
        this.tenantId,
        this.decisionId,
        this.decisionName,
        this.version,
        this.decisionKey,
        this.decisionRequirementsId,
        this.decisionRequirementsKey,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableDecisionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableDecisionRecordValue
        && equalTo(0, (ImmutableDecisionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableDecisionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && Objects.equals(decisionId, another.decisionId)
        && Objects.equals(decisionName, another.decisionName)
        && version == another.version
        && decisionKey == another.decisionKey
        && Objects.equals(decisionRequirementsId, another.decisionRequirementsId)
        && decisionRequirementsKey == another.decisionRequirementsKey
        && duplicate == another.duplicate;
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code decisionId}, {@code decisionName}, {@code version}, {@code decisionKey}, {@code decisionRequirementsId}, {@code decisionRequirementsKey}, {@code duplicate}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Objects.hashCode(decisionId);
    h += (h << 5) + Objects.hashCode(decisionName);
    h += (h << 5) + version;
    h += (h << 5) + Long.hashCode(decisionKey);
    h += (h << 5) + Objects.hashCode(decisionRequirementsId);
    h += (h << 5) + Long.hashCode(decisionRequirementsKey);
    h += (h << 5) + Boolean.hashCode(duplicate);
    return h;
  }

  /**
   * Prints the immutable value {@code DecisionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DecisionRecordValue{"
        + "tenantId=" + tenantId
        + ", decisionId=" + decisionId
        + ", decisionName=" + decisionName
        + ", version=" + version
        + ", decisionKey=" + decisionKey
        + ", decisionRequirementsId=" + decisionRequirementsId
        + ", decisionRequirementsKey=" + decisionRequirementsKey
        + ", duplicate=" + duplicate
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link DecisionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable DecisionRecordValue instance
   */
  public static ImmutableDecisionRecordValue copyOf(DecisionRecordValue instance) {
    if (instance instanceof ImmutableDecisionRecordValue) {
      return (ImmutableDecisionRecordValue) instance;
    }
    return ImmutableDecisionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableDecisionRecordValue ImmutableDecisionRecordValue}.
   * <pre>
   * ImmutableDecisionRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link DecisionRecordValue#getTenantId() tenantId}
   *    .withDecisionId(String | null) // nullable {@link DecisionRecordValue#getDecisionId() decisionId}
   *    .withDecisionName(String | null) // nullable {@link DecisionRecordValue#getDecisionName() decisionName}
   *    .withVersion(int) // optional {@link DecisionRecordValue#getVersion() version}
   *    .withDecisionKey(long) // optional {@link DecisionRecordValue#getDecisionKey() decisionKey}
   *    .withDecisionRequirementsId(String | null) // nullable {@link DecisionRecordValue#getDecisionRequirementsId() decisionRequirementsId}
   *    .withDecisionRequirementsKey(long) // optional {@link DecisionRecordValue#getDecisionRequirementsKey() decisionRequirementsKey}
   *    .withDuplicate(boolean) // optional {@link DecisionRecordValue#isDuplicate() duplicate}
   *    .build();
   * </pre>
   * @return A new ImmutableDecisionRecordValue builder
   */
  public static ImmutableDecisionRecordValue.Builder builder() {
    return new ImmutableDecisionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableDecisionRecordValue ImmutableDecisionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "DecisionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private String decisionId;
    private String decisionName;
    private int version;
    private long decisionKey;
    private String decisionRequirementsId;
    private long decisionRequirementsKey;
    private boolean duplicate;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.deployment.DecisionRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DecisionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.TenantOwned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TenantOwned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof DecisionRecordValue) {
        DecisionRecordValue instance = (DecisionRecordValue) object;
        withDecisionRequirementsKey(instance.getDecisionRequirementsKey());
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
        withDecisionKey(instance.getDecisionKey());
        withDuplicate(instance.isDuplicate());
        String decisionIdValue = instance.getDecisionId();
        if (decisionIdValue != null) {
          withDecisionId(decisionIdValue);
        }
        withVersion(instance.getVersion());
        String decisionNameValue = instance.getDecisionName();
        if (decisionNameValue != null) {
          withDecisionName(decisionNameValue);
        }
        String decisionRequirementsIdValue = instance.getDecisionRequirementsId();
        if (decisionRequirementsIdValue != null) {
          withDecisionRequirementsId(decisionRequirementsIdValue);
        }
      }
      if (object instanceof TenantOwned) {
        TenantOwned instance = (TenantOwned) object;
        if ((bits & 0x1L) == 0) {
          String tenantIdValue = instance.getTenantId();
          if (tenantIdValue != null) {
            withTenantId(tenantIdValue);
          }
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getDecisionId() decisionId} attribute.
     * @param decisionId The value for decisionId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionId(String decisionId) {
      this.decisionId = decisionId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getDecisionName() decisionName} attribute.
     * @param decisionName The value for decisionName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionName(String decisionName) {
      this.decisionName = decisionName;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVersion(int version) {
      this.version = version;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getDecisionKey() decisionKey} attribute.
     * @param decisionKey The value for decisionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionKey(long decisionKey) {
      this.decisionKey = decisionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getDecisionRequirementsId() decisionRequirementsId} attribute.
     * @param decisionRequirementsId The value for decisionRequirementsId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsId(String decisionRequirementsId) {
      this.decisionRequirementsId = decisionRequirementsId;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#getDecisionRequirementsKey() decisionRequirementsKey} attribute.
     * @param decisionRequirementsKey The value for decisionRequirementsKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDecisionRequirementsKey(long decisionRequirementsKey) {
      this.decisionRequirementsKey = decisionRequirementsKey;
      return this;
    }

    /**
     * Initializes the value for the {@link DecisionRecordValue#isDuplicate() duplicate} attribute.
     * @param duplicate The value for duplicate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withDuplicate(boolean duplicate) {
      this.duplicate = duplicate;
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.decisionId = null;
      this.decisionName = null;
      this.version = 0;
      this.decisionKey = 0;
      this.decisionRequirementsId = null;
      this.decisionRequirementsKey = 0;
      this.duplicate = false;
      return this;
    }

    /**
     * Builds a new {@link ImmutableDecisionRecordValue ImmutableDecisionRecordValue}.
     * @return An immutable instance of DecisionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableDecisionRecordValue build() {
      return new ImmutableDecisionRecordValue(
          tenantId,
          decisionId,
          decisionName,
          version,
          decisionKey,
          decisionRequirementsId,
          decisionRequirementsKey,
          duplicate);
    }



  }



}
