package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CompensationSubscriptionRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCompensationSubscriptionRecordValue.builder()}.
 */
@Generated(from = "CompensationSubscriptionRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableCompensationSubscriptionRecordValue.Builder.class)
public final class ImmutableCompensationSubscriptionRecordValue
    implements CompensationSubscriptionRecordValue {
  private final String tenantId;
  private final long processInstanceKey;
  private final long processDefinitionKey;
  private final String compensableActivityId;
  private final long compensableActivityScopeId;
  private final String throwEventId;
  private final long throwEventInstanceKey;
  private final Map<String, Object> variables;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableCompensationSubscriptionRecordValue(
      String tenantId,
      long processInstanceKey,
      long processDefinitionKey,
      String compensableActivityId,
      long compensableActivityScopeId,
      String throwEventId,
      long throwEventInstanceKey,
      Map<String, Object> variables) {
    this.tenantId = tenantId;
    this.processInstanceKey = processInstanceKey;
    this.processDefinitionKey = processDefinitionKey;
    this.compensableActivityId = compensableActivityId;
    this.compensableActivityScopeId = compensableActivityScopeId;
    this.throwEventId = throwEventId;
    this.throwEventInstanceKey = throwEventInstanceKey;
    this.variables = variables;
  }

  /**
   * @return the id of the tenant
   */
  @Override
  public String getTenantId() {
    return tenantId;
  }

  /**
   * @return the key of the process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the key of the process definition
   */
  @Override
  public long getProcessDefinitionKey() {
    return processDefinitionKey;
  }

  /**
   * @return the element id of the activity with the compensation handler
   */
  @Override
  public String getCompensableActivityId() {
    return compensableActivityId;
  }

  /**
   * @return the element id of the flow scope that contains the activity with the compensation
   *     handler
   */
  @Override
  public long getCompensableActivityScopeId() {
    return compensableActivityScopeId;
  }

  /**
   * @return the element id of compensation throw event
   */
  @Override
  public String getThrowEventId() {
    return throwEventId;
  }

  /**
   * @return the element instance key of compensation throw event
   */
  @Override
  public long getThrowEventInstanceKey() {
    return throwEventInstanceKey;
  }

  /**
   * @return the local variables of activity with compensation handler
   */
  @Override
  public Map<String, Object> getVariables() {
    return variables;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getTenantId() tenantId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tenantId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withTenantId(String value) {
    if (Objects.equals(this.tenantId, value)) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        value,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        this.throwEventId,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        value,
        this.processDefinitionKey,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        this.throwEventId,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withProcessDefinitionKey(long value) {
    if (this.processDefinitionKey == value) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        value,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        this.throwEventId,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getCompensableActivityId() compensableActivityId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compensableActivityId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withCompensableActivityId(String value) {
    if (Objects.equals(this.compensableActivityId, value)) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        this.processDefinitionKey,
        value,
        this.compensableActivityScopeId,
        this.throwEventId,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getCompensableActivityScopeId() compensableActivityScopeId} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for compensableActivityScopeId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withCompensableActivityScopeId(long value) {
    if (this.compensableActivityScopeId == value) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.compensableActivityId,
        value,
        this.throwEventId,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getThrowEventId() throwEventId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throwEventId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withThrowEventId(String value) {
    if (Objects.equals(this.throwEventId, value)) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        value,
        this.throwEventInstanceKey,
        this.variables);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CompensationSubscriptionRecordValue#getThrowEventInstanceKey() throwEventInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for throwEventInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withThrowEventInstanceKey(long value) {
    if (this.throwEventInstanceKey == value) return this;
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        this.throwEventId,
        value,
        this.variables);
  }

  /**
   * Copy the current immutable object by replacing the {@link CompensationSubscriptionRecordValue#getVariables() variables} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the variables map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCompensationSubscriptionRecordValue withVariables(Map<String, ? extends Object> entries) {
    if (this.variables == entries) return this;
    Map<String, Object> newValue = createUnmodifiableMap(false, false, entries);
    return new ImmutableCompensationSubscriptionRecordValue(
        this.tenantId,
        this.processInstanceKey,
        this.processDefinitionKey,
        this.compensableActivityId,
        this.compensableActivityScopeId,
        this.throwEventId,
        this.throwEventInstanceKey,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCompensationSubscriptionRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCompensationSubscriptionRecordValue
        && equalTo(0, (ImmutableCompensationSubscriptionRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableCompensationSubscriptionRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(tenantId, another.tenantId)
        && processInstanceKey == another.processInstanceKey
        && processDefinitionKey == another.processDefinitionKey
        && Objects.equals(compensableActivityId, another.compensableActivityId)
        && compensableActivityScopeId == another.compensableActivityScopeId
        && Objects.equals(throwEventId, another.throwEventId)
        && throwEventInstanceKey == another.throwEventInstanceKey
        && variables.equals(another.variables);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code tenantId}, {@code processInstanceKey}, {@code processDefinitionKey}, {@code compensableActivityId}, {@code compensableActivityScopeId}, {@code throwEventId}, {@code throwEventInstanceKey}, {@code variables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(tenantId);
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(processDefinitionKey);
    h += (h << 5) + Objects.hashCode(compensableActivityId);
    h += (h << 5) + Long.hashCode(compensableActivityScopeId);
    h += (h << 5) + Objects.hashCode(throwEventId);
    h += (h << 5) + Long.hashCode(throwEventInstanceKey);
    h += (h << 5) + variables.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CompensationSubscriptionRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CompensationSubscriptionRecordValue{"
        + "tenantId=" + tenantId
        + ", processInstanceKey=" + processInstanceKey
        + ", processDefinitionKey=" + processDefinitionKey
        + ", compensableActivityId=" + compensableActivityId
        + ", compensableActivityScopeId=" + compensableActivityScopeId
        + ", throwEventId=" + throwEventId
        + ", throwEventInstanceKey=" + throwEventInstanceKey
        + ", variables=" + variables
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CompensationSubscriptionRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CompensationSubscriptionRecordValue instance
   */
  public static ImmutableCompensationSubscriptionRecordValue copyOf(CompensationSubscriptionRecordValue instance) {
    if (instance instanceof ImmutableCompensationSubscriptionRecordValue) {
      return (ImmutableCompensationSubscriptionRecordValue) instance;
    }
    return ImmutableCompensationSubscriptionRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCompensationSubscriptionRecordValue ImmutableCompensationSubscriptionRecordValue}.
   * <pre>
   * ImmutableCompensationSubscriptionRecordValue.builder()
   *    .withTenantId(String | null) // nullable {@link CompensationSubscriptionRecordValue#getTenantId() tenantId}
   *    .withProcessInstanceKey(long) // optional {@link CompensationSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withProcessDefinitionKey(long) // optional {@link CompensationSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey}
   *    .withCompensableActivityId(String | null) // nullable {@link CompensationSubscriptionRecordValue#getCompensableActivityId() compensableActivityId}
   *    .withCompensableActivityScopeId(long) // optional {@link CompensationSubscriptionRecordValue#getCompensableActivityScopeId() compensableActivityScopeId}
   *    .withThrowEventId(String | null) // nullable {@link CompensationSubscriptionRecordValue#getThrowEventId() throwEventId}
   *    .withThrowEventInstanceKey(long) // optional {@link CompensationSubscriptionRecordValue#getThrowEventInstanceKey() throwEventInstanceKey}
   *    .putVariable|putAllVariables(String =&gt; Object) // {@link CompensationSubscriptionRecordValue#getVariables() variables} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableCompensationSubscriptionRecordValue builder
   */
  public static ImmutableCompensationSubscriptionRecordValue.Builder builder() {
    return new ImmutableCompensationSubscriptionRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCompensationSubscriptionRecordValue ImmutableCompensationSubscriptionRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CompensationSubscriptionRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String tenantId;
    private long processInstanceKey;
    private long processDefinitionKey;
    private String compensableActivityId;
    private long compensableActivityScopeId;
    private String throwEventId;
    private long throwEventInstanceKey;
    private Map<String, Object> variables = new LinkedHashMap<String, Object>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CompensationSubscriptionRecordValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CompensationSubscriptionRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      String tenantIdValue = instance.getTenantId();
      if (tenantIdValue != null) {
        withTenantId(tenantIdValue);
      }
      withProcessInstanceKey(instance.getProcessInstanceKey());
      withProcessDefinitionKey(instance.getProcessDefinitionKey());
      String compensableActivityIdValue = instance.getCompensableActivityId();
      if (compensableActivityIdValue != null) {
        withCompensableActivityId(compensableActivityIdValue);
      }
      withCompensableActivityScopeId(instance.getCompensableActivityScopeId());
      String throwEventIdValue = instance.getThrowEventId();
      if (throwEventIdValue != null) {
        withThrowEventId(throwEventIdValue);
      }
      withThrowEventInstanceKey(instance.getThrowEventInstanceKey());
      putAllVariables(instance.getVariables());
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getTenantId() tenantId} attribute.
     * @param tenantId The value for tenantId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTenantId(String tenantId) {
      this.tenantId = tenantId;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getProcessDefinitionKey() processDefinitionKey} attribute.
     * @param processDefinitionKey The value for processDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessDefinitionKey(long processDefinitionKey) {
      this.processDefinitionKey = processDefinitionKey;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getCompensableActivityId() compensableActivityId} attribute.
     * @param compensableActivityId The value for compensableActivityId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCompensableActivityId(String compensableActivityId) {
      this.compensableActivityId = compensableActivityId;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getCompensableActivityScopeId() compensableActivityScopeId} attribute.
     * @param compensableActivityScopeId The value for compensableActivityScopeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withCompensableActivityScopeId(long compensableActivityScopeId) {
      this.compensableActivityScopeId = compensableActivityScopeId;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getThrowEventId() throwEventId} attribute.
     * @param throwEventId The value for throwEventId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withThrowEventId(String throwEventId) {
      this.throwEventId = throwEventId;
      return this;
    }

    /**
     * Initializes the value for the {@link CompensationSubscriptionRecordValue#getThrowEventInstanceKey() throwEventInstanceKey} attribute.
     * @param throwEventInstanceKey The value for throwEventInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withThrowEventInstanceKey(long throwEventInstanceKey) {
      this.throwEventInstanceKey = throwEventInstanceKey;
      return this;
    }

    /**
     * Put one entry to the {@link CompensationSubscriptionRecordValue#getVariables() variables} map.
     * @param key The key in the variables map
     * @param value The associated value in the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(String key, Object value) {
      this.variables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CompensationSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.variables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CompensationSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariables(Map<String, ? extends Object> entries) {
      this.variables.clear();
      return putAllVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CompensationSubscriptionRecordValue#getVariables() variables} map. Nulls are not permitted
     * @param entries The entries that will be added to the variables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVariables(Map<String, ? extends Object> entries) {
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.variables.put(k, v);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.tenantId = null;
      this.processInstanceKey = 0;
      this.processDefinitionKey = 0;
      this.compensableActivityId = null;
      this.compensableActivityScopeId = 0;
      this.throwEventId = null;
      this.throwEventInstanceKey = 0;
      this.variables.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableCompensationSubscriptionRecordValue ImmutableCompensationSubscriptionRecordValue}.
     * @return An immutable instance of CompensationSubscriptionRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCompensationSubscriptionRecordValue build() {
      return new ImmutableCompensationSubscriptionRecordValue(
          tenantId,
          processInstanceKey,
          processDefinitionKey,
          compensableActivityId,
          compensableActivityScopeId,
          throwEventId,
          throwEventInstanceKey,
          createUnmodifiableMap(false, false, variables));
    }



  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size() * 4 / 3 + 1);
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }



}
