package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceMigrationRecordValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceMigrationRecordValue.builder()}.
 */
@Generated(from = "ProcessInstanceMigrationRecordValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceMigrationRecordValue.Builder.class)
public final class ImmutableProcessInstanceMigrationRecordValue
    implements ProcessInstanceMigrationRecordValue {
  private final long processInstanceKey;
  private final long targetProcessDefinitionKey;
  private final List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceMigrationRecordValue(
      long processInstanceKey,
      long targetProcessDefinitionKey,
      List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> mappingInstructions) {
    this.processInstanceKey = processInstanceKey;
    this.targetProcessDefinitionKey = targetProcessDefinitionKey;
    this.mappingInstructions = mappingInstructions;
  }

  /**
   * @return the key of the corresponding process instance
   */
  @Override
  public long getProcessInstanceKey() {
    return processInstanceKey;
  }

  /**
   * @return the key of the process definition to migrate to
   */
  @Override
  public long getTargetProcessDefinitionKey() {
    return targetProcessDefinitionKey;
  }

  /**
   * @return the mapping instructions, or an empty list if no instructions are available
   */
  @Override
  public List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> getMappingInstructions() {
    return mappingInstructions;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceMigrationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for processInstanceKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceMigrationRecordValue withProcessInstanceKey(long value) {
    if (this.processInstanceKey == value) return this;
    return new ImmutableProcessInstanceMigrationRecordValue(value, this.targetProcessDefinitionKey, this.mappingInstructions);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceMigrationRecordValue#getTargetProcessDefinitionKey() targetProcessDefinitionKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for targetProcessDefinitionKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceMigrationRecordValue withTargetProcessDefinitionKey(long value) {
    if (this.targetProcessDefinitionKey == value) return this;
    return new ImmutableProcessInstanceMigrationRecordValue(this.processInstanceKey, value, this.mappingInstructions);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceMigrationRecordValue withMappingInstructions(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue... elements) {
    List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceMigrationRecordValue(this.processInstanceKey, this.targetProcessDefinitionKey, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of mappingInstructions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceMigrationRecordValue withMappingInstructions(Iterable<? extends ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> elements) {
    if (this.mappingInstructions == elements) return this;
    List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableProcessInstanceMigrationRecordValue(this.processInstanceKey, this.targetProcessDefinitionKey, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceMigrationRecordValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceMigrationRecordValue
        && equalTo(0, (ImmutableProcessInstanceMigrationRecordValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceMigrationRecordValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return processInstanceKey == another.processInstanceKey
        && targetProcessDefinitionKey == another.targetProcessDefinitionKey
        && mappingInstructions.equals(another.mappingInstructions);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code processInstanceKey}, {@code targetProcessDefinitionKey}, {@code mappingInstructions}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Long.hashCode(processInstanceKey);
    h += (h << 5) + Long.hashCode(targetProcessDefinitionKey);
    h += (h << 5) + mappingInstructions.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceMigrationRecordValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceMigrationRecordValue{"
        + "processInstanceKey=" + processInstanceKey
        + ", targetProcessDefinitionKey=" + targetProcessDefinitionKey
        + ", mappingInstructions=" + mappingInstructions
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceMigrationRecordValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceMigrationRecordValue instance
   */
  public static ImmutableProcessInstanceMigrationRecordValue copyOf(ProcessInstanceMigrationRecordValue instance) {
    if (instance instanceof ImmutableProcessInstanceMigrationRecordValue) {
      return (ImmutableProcessInstanceMigrationRecordValue) instance;
    }
    return ImmutableProcessInstanceMigrationRecordValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceMigrationRecordValue ImmutableProcessInstanceMigrationRecordValue}.
   * <pre>
   * ImmutableProcessInstanceMigrationRecordValue.builder()
   *    .withProcessInstanceKey(long) // optional {@link ProcessInstanceMigrationRecordValue#getProcessInstanceKey() processInstanceKey}
   *    .withTargetProcessDefinitionKey(long) // optional {@link ProcessInstanceMigrationRecordValue#getTargetProcessDefinitionKey() targetProcessDefinitionKey}
   *    .addMappingInstruction|addAllMappingInstructions(io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue) // {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceMigrationRecordValue builder
   */
  public static ImmutableProcessInstanceMigrationRecordValue.Builder builder() {
    return new ImmutableProcessInstanceMigrationRecordValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceMigrationRecordValue ImmutableProcessInstanceMigrationRecordValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceMigrationRecordValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private long processInstanceKey;
    private long targetProcessDefinitionKey;
    private List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> mappingInstructions = new ArrayList<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceMigrationRecordValue} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceMigrationRecordValue instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceRelated instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      long bits = 0;
      if (object instanceof ProcessInstanceMigrationRecordValue) {
        ProcessInstanceMigrationRecordValue instance = (ProcessInstanceMigrationRecordValue) object;
        addAllMappingInstructions(instance.getMappingInstructions());
        withTargetProcessDefinitionKey(instance.getTargetProcessDefinitionKey());
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
      if (object instanceof ProcessInstanceRelated) {
        ProcessInstanceRelated instance = (ProcessInstanceRelated) object;
        if ((bits & 0x1L) == 0) {
          withProcessInstanceKey(instance.getProcessInstanceKey());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link ProcessInstanceMigrationRecordValue#getProcessInstanceKey() processInstanceKey} attribute.
     * @param processInstanceKey The value for processInstanceKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withProcessInstanceKey(long processInstanceKey) {
      this.processInstanceKey = processInstanceKey;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceMigrationRecordValue#getTargetProcessDefinitionKey() targetProcessDefinitionKey} attribute.
     * @param targetProcessDefinitionKey The value for targetProcessDefinitionKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withTargetProcessDefinitionKey(long targetProcessDefinitionKey) {
      this.targetProcessDefinitionKey = targetProcessDefinitionKey;
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param element A mappingInstructions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMappingInstruction(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(element);
      this.mappingInstructions.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param elements An array of mappingInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMappingInstructions(ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue... elements) {
      for (ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(element);
        this.mappingInstructions.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list and returns
     * the builder.
     */
    public final ImmutableProcessInstanceMigrationMappingInstructionValue.Builder addMappingInstructionBuilder() {
      ImmutableProcessInstanceMigrationMappingInstructionValue.Builder builder = ImmutableProcessInstanceMigrationMappingInstructionValue.builder();
      this.mappingInstructions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param elements An array of mappingInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMappingInstructionBuilders(ImmutableProcessInstanceMigrationMappingInstructionValue.Builder... elements) {
      for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : elements) {
        this.mappingInstructions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> mappingInstructionBuilders() {
      return createUnmodifiableList(false, this.mappingInstructions);
    }

    /**
     * Sets or replaces all elements for {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param elements An iterable of mappingInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withMappingInstructions(Iterable<? extends ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> elements) {
      this.mappingInstructions.clear();
      return addAllMappingInstructions(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param elements An iterable of mappingInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMappingInstructions(Iterable<? extends ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> elements) {
      for (ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(element);
        this.mappingInstructions.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceMigrationRecordValue#getMappingInstructions() mappingInstructions} list.
     * @param elements An iterable of mappingInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMappingInstructionBuilders(Iterable<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> elements) {
      for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : elements) {
        this.mappingInstructions.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.processInstanceKey = 0;
      this.targetProcessDefinitionKey = 0;
      this.mappingInstructions.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceMigrationRecordValue ImmutableProcessInstanceMigrationRecordValue}.
     * @return An immutable instance of ProcessInstanceMigrationRecordValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceMigrationRecordValue build() {
      return new ImmutableProcessInstanceMigrationRecordValue(
          processInstanceKey,
          targetProcessDefinitionKey,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(mappingInstructions)));
    }



    
    private static ImmutableProcessInstanceMigrationMappingInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ImmutableProcessInstanceMigrationMappingInstructionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(value).build();
    }

    
    private static ImmutableProcessInstanceMigrationMappingInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(value);
    }

    private static List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(Iterable<? extends ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> builderList) {
      ArrayList<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(ImmutableProcessInstanceMigrationMappingInstructionValue.Builder... builderArray) {
      ArrayList<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(builderArray.length);
      for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(Iterable<? extends ImmutableProcessInstanceMigrationMappingInstructionValue> valueList) {
      ArrayList<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableProcessInstanceMigrationMappingInstructionValue element : valueList) {
        list.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(ImmutableProcessInstanceMigrationMappingInstructionValue... valueArray) {
      ArrayList<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(valueArray.length);
      for (ImmutableProcessInstanceMigrationMappingInstructionValue element : valueArray) {
        list.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }



  
  private static ImmutableProcessInstanceMigrationMappingInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ImmutableProcessInstanceMigrationMappingInstructionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(value).build();
  }

  
  private static ImmutableProcessInstanceMigrationMappingInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue( ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(value);
  }

  private static List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(Iterable<? extends ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> builderList) {
    ArrayList<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(ImmutableProcessInstanceMigrationMappingInstructionValue.Builder... builderArray) {
    ArrayList<ProcessInstanceMigrationRecordValue.ProcessInstanceMigrationMappingInstructionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(builderArray.length);
    for (ImmutableProcessInstanceMigrationMappingInstructionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(Iterable<? extends ImmutableProcessInstanceMigrationMappingInstructionValue> valueList) {
    ArrayList<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableProcessInstanceMigrationMappingInstructionValue element : valueList) {
      list.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceMigrationMappingInstructionValue(ImmutableProcessInstanceMigrationMappingInstructionValue... valueArray) {
    ArrayList<ImmutableProcessInstanceMigrationMappingInstructionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(valueArray.length);
    for (ImmutableProcessInstanceMigrationMappingInstructionValue element : valueArray) {
      list.add(ImmutableProcessInstanceMigrationMappingInstructionValue.builder().from(element));
    }
    return list;
  }
}
