package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProcessInstanceModificationActivateInstructionValue.builder()}.
 */
@Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue", generator = "Immutables")
@SuppressWarnings({"all"})
@SuppressFBWarnings
@ImmutableProtocol.Type(builder=ImmutableProcessInstanceModificationActivateInstructionValue.Builder.class)
public final class ImmutableProcessInstanceModificationActivateInstructionValue
    implements ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue {
  private final String elementId;
  private final long ancestorScopeKey;
  private final List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> variableInstructions;
  private final Set<Long> ancestorScopeKeys;
  private transient int hashCode; // hashCode lazily computed

  private ImmutableProcessInstanceModificationActivateInstructionValue(
      String elementId,
      long ancestorScopeKey,
      List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> variableInstructions,
      Set<Long> ancestorScopeKeys) {
    this.elementId = elementId;
    this.ancestorScopeKey = ancestorScopeKey;
    this.variableInstructions = variableInstructions;
    this.ancestorScopeKeys = ancestorScopeKeys;
  }

  /**
   *Returns the id of the element to create a new element instance at. 
   */
  @Override
  public String getElementId() {
    return elementId;
  }

  /**
   * Returns the key of the ancestor scope to create the new element instance in, or -1 if no
   * specific ancestor is selected.
   * <p>This key is used for ancestor selection:
   * <p>By default, the new element instance is created within an existing element instance of the
   * flow scope. For example, when activating an element inside an embedded subprocess and the
   * subprocess is already active.
   * <p>If there is more than one element instance of the flow scope active then the engine can't
   * decide which element instance to create the new element instance in. Instead, the element
   * instance must be selected by its element instance key. The new element instance is created
   * within the selected element instance.
   * <p>If the selected element instance is not of the flow scope but from a higher scope (e.g.
   * the process instance key instead of the element instance key of the subprocess) then the
   * engine creates a new element instance of the flow scope first and then creates the new
   * element instance within this scope.
   */
  @Override
  public long getAncestorScopeKey() {
    return ancestorScopeKey;
  }

  /**
   *Returns a list of variable instructions (if available), or an empty list. 
   */
  @Override
  public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> getVariableInstructions() {
    return variableInstructions;
  }

  /**
   * Returns all ancestor scope keys of the element that will be activated. The property is set in
   * the event only after the modification is applied.
   */
  @Override
  public Set<Long> getAncestorScopeKeys() {
    return ancestorScopeKeys;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getElementId() elementId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for elementId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withElementId(String value) {
    if (Objects.equals(this.elementId, value)) return this;
    return new ImmutableProcessInstanceModificationActivateInstructionValue(value, this.ancestorScopeKey, this.variableInstructions, this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKey() ancestorScopeKey} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ancestorScopeKey
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withAncestorScopeKey(long value) {
    if (this.ancestorScopeKey == value) return this;
    return new ImmutableProcessInstanceModificationActivateInstructionValue(this.elementId, value, this.variableInstructions, this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withVariableInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue... elements) {
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceModificationActivateInstructionValue(this.elementId, this.ancestorScopeKey, newValue, this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of variableInstructions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withVariableInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> elements) {
    if (this.variableInstructions == elements) return this;
    List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> newValue = createUnmodifiableList(false, createSafeList(elements, false, false));
    return new ImmutableProcessInstanceModificationActivateInstructionValue(this.elementId, this.ancestorScopeKey, newValue, this.ancestorScopeKeys);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withAncestorScopeKeys(Long... elements) {
    Set<Long> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), false, false));
    return new ImmutableProcessInstanceModificationActivateInstructionValue(this.elementId, this.ancestorScopeKey, this.variableInstructions, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of ancestorScopeKeys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProcessInstanceModificationActivateInstructionValue withAncestorScopeKeys(Iterable<? extends Long> elements) {
    if (this.ancestorScopeKeys == elements) return this;
    Set<Long> newValue = createUnmodifiableSet(createSafeList(elements, false, false));
    return new ImmutableProcessInstanceModificationActivateInstructionValue(this.elementId, this.ancestorScopeKey, this.variableInstructions, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProcessInstanceModificationActivateInstructionValue} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProcessInstanceModificationActivateInstructionValue
        && equalTo(0, (ImmutableProcessInstanceModificationActivateInstructionValue) another);
  }

  private boolean equalTo(int synthetic, ImmutableProcessInstanceModificationActivateInstructionValue another) {
    if (hashCode != 0 && another.hashCode != 0 && hashCode != another.hashCode) return false;
    return Objects.equals(elementId, another.elementId)
        && ancestorScopeKey == another.ancestorScopeKey
        && variableInstructions.equals(another.variableInstructions)
        && ancestorScopeKeys.equals(another.ancestorScopeKeys);
  }

  /**
   * Returns a lazily computed hash code from attributes: {@code elementId}, {@code ancestorScopeKey}, {@code variableInstructions}, {@code ancestorScopeKeys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = this.hashCode;
    if (h == 0) {
      h = computeHashCode();
      this.hashCode = h;
    }
    return h;
  }

  private int computeHashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(elementId);
    h += (h << 5) + Long.hashCode(ancestorScopeKey);
    h += (h << 5) + variableInstructions.hashCode();
    h += (h << 5) + ancestorScopeKeys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProcessInstanceModificationActivateInstructionValue} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProcessInstanceModificationActivateInstructionValue{"
        + "elementId=" + elementId
        + ", ancestorScopeKey=" + ancestorScopeKey
        + ", variableInstructions=" + variableInstructions
        + ", ancestorScopeKeys=" + ancestorScopeKeys
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProcessInstanceModificationActivateInstructionValue instance
   */
  public static ImmutableProcessInstanceModificationActivateInstructionValue copyOf(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue instance) {
    if (instance instanceof ImmutableProcessInstanceModificationActivateInstructionValue) {
      return (ImmutableProcessInstanceModificationActivateInstructionValue) instance;
    }
    return ImmutableProcessInstanceModificationActivateInstructionValue.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProcessInstanceModificationActivateInstructionValue ImmutableProcessInstanceModificationActivateInstructionValue}.
   * <pre>
   * ImmutableProcessInstanceModificationActivateInstructionValue.builder()
   *    .withElementId(String | null) // nullable {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getElementId() elementId}
   *    .withAncestorScopeKey(long) // optional {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKey() ancestorScopeKey}
   *    .addVariableInstruction|addAllVariableInstructions(io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue) // {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} elements
   *    .addAncestorScopeKey|addAllAncestorScopeKeys(Long) // {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys} elements
   *    .build();
   * </pre>
   * @return A new ImmutableProcessInstanceModificationActivateInstructionValue builder
   */
  public static ImmutableProcessInstanceModificationActivateInstructionValue.Builder builder() {
    return new ImmutableProcessInstanceModificationActivateInstructionValue.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProcessInstanceModificationActivateInstructionValue ImmutableProcessInstanceModificationActivateInstructionValue}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue", generator = "Immutables")
  @ImmutableProtocol.Builder
  public static final class Builder {
    private String elementId;
    private long ancestorScopeKey;
    private List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> variableInstructions = new ArrayList<ImmutableProcessInstanceModificationVariableInstructionValue.Builder>();
    private List<Long> ancestorScopeKeys = new ArrayList<Long>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProcessInstanceModificationActivateInstructionValue} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue instance) {
      Objects.requireNonNull(instance, "instance");
      String elementIdValue = instance.getElementId();
      if (elementIdValue != null) {
        withElementId(elementIdValue);
      }
      withAncestorScopeKey(instance.getAncestorScopeKey());
      addAllVariableInstructions(instance.getVariableInstructions());
      addAllAncestorScopeKeys(instance.getAncestorScopeKeys());
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getElementId() elementId} attribute.
     * @param elementId The value for elementId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withElementId(String elementId) {
      this.elementId = elementId;
      return this;
    }

    /**
     * Initializes the value for the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKey() ancestorScopeKey} attribute.
     * @param ancestorScopeKey The value for ancestorScopeKey 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAncestorScopeKey(long ancestorScopeKey) {
      this.ancestorScopeKey = ancestorScopeKey;
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param element A variableInstructions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariableInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue element) {
      if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(element);
      this.variableInstructions.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param elements An array of variableInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addVariableInstructions(ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue... elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(element);
        this.variableInstructions.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds a new builder to the {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list and returns
     * the builder.
     */
    public final ImmutableProcessInstanceModificationVariableInstructionValue.Builder addVariableInstructionBuilder() {
      ImmutableProcessInstanceModificationVariableInstructionValue.Builder builder = ImmutableProcessInstanceModificationVariableInstructionValue.builder();
      this.variableInstructions.add(builder);
      return builder;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param elements An array of variableInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariableInstructionBuilders(ImmutableProcessInstanceModificationVariableInstructionValue.Builder... elements) {
      for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : elements) {
        this.variableInstructions.add(element);
      }
      return this;
    }

    /**
     * Gets the builder elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @return {@code this} unmodifiable list of modifiable builders.
     */
    public final List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> variableInstructionBuilders() {
      return createUnmodifiableList(false, this.variableInstructions);
    }

    /**
     * Sets or replaces all elements for {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param elements An iterable of variableInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withVariableInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> elements) {
      this.variableInstructions.clear();
      return addAllVariableInstructions(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param elements An iterable of variableInstructions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariableInstructions(Iterable<? extends ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> elements) {
      for (ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue element : elements) {
        if (element != null) element = convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(element);
        this.variableInstructions.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
      }
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getVariableInstructions() variableInstructions} list.
     * @param elements An iterable of variableInstructions builder elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllVariableInstructionBuilders(Iterable<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> elements) {
      for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : elements) {
        this.variableInstructions.add(element);
      }
      return this;
    }

    /**
     * Adds one element to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param element A ancestorScopeKeys element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAncestorScopeKey(Long element) {
      this.ancestorScopeKeys.add(element);
      return this;
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An array of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAncestorScopeKeys(Long... elements) {
      for (Long element : elements) {
        this.ancestorScopeKeys.add(element);
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An iterable of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder withAncestorScopeKeys(Iterable<? extends Long> elements) {
      this.ancestorScopeKeys.clear();
      return addAllAncestorScopeKeys(elements);
    }

    /**
     * Adds elements to {@link ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue#getAncestorScopeKeys() ancestorScopeKeys} set.
     * @param elements An iterable of ancestorScopeKeys elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAncestorScopeKeys(Iterable<? extends Long> elements) {
      for (Long element : elements) {
        this.ancestorScopeKeys.add(element);
      }
      return this;
    }

    /**
     * Clear the builder to the initial state.
     * @return {@code this} builder for use in a chained invocation
     */
    public Builder clear() {
      this.elementId = null;
      this.ancestorScopeKey = 0;
      this.variableInstructions.clear();
      this.ancestorScopeKeys.clear();
      return this;
    }

    /**
     * Builds a new {@link ImmutableProcessInstanceModificationActivateInstructionValue ImmutableProcessInstanceModificationActivateInstructionValue}.
     * @return An immutable instance of ProcessInstanceModificationActivateInstructionValue
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProcessInstanceModificationActivateInstructionValue build() {
      return new ImmutableProcessInstanceModificationActivateInstructionValue(
          elementId,
          ancestorScopeKey,
          createUnmodifiableList(true, convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(variableInstructions)),
          createUnmodifiableSet(ancestorScopeKeys));
    }



    
    private static ImmutableProcessInstanceModificationVariableInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ImmutableProcessInstanceModificationVariableInstructionValue.Builder builder) {
      if (builder == null) return null;
      return builder.build();
    }

    
    private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(value).build();
    }

    
    private static ImmutableProcessInstanceModificationVariableInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue value) {
      if (value == null) return null;
      return ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(value);
    }

    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationVariableInstructionValue.Builder> builderList) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> list;
      if (builderList instanceof Collection<?>) {
        int size = ((Collection<?>) builderList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : builderList) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(ImmutableProcessInstanceModificationVariableInstructionValue.Builder... builderArray) {
      ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> list;
      if (builderArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(builderArray.length);
      for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : builderArray) {
        list.add(element.build());
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationVariableInstructionValue> valueList) {
      ArrayList<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> list;
      if (valueList instanceof Collection<?>) {
        int size = ((Collection<?>) valueList).size();
        if (size == 0) return Collections.emptyList();
        list = new ArrayList<>(size);
      } else {
        list = new ArrayList<>();
      }
      for (ImmutableProcessInstanceModificationVariableInstructionValue element : valueList) {
        list.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
      }
      return list;
    }

    private static List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(ImmutableProcessInstanceModificationVariableInstructionValue... valueArray) {
      ArrayList<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> list;
      if (valueArray.length == 0) return Collections.emptyList();
      list = new ArrayList<>(valueArray.length);
      for (ImmutableProcessInstanceModificationVariableInstructionValue element : valueArray) {
        list.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
      }
      return list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size() * 4 / 3 + 1);
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }



  
  private static ImmutableProcessInstanceModificationVariableInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ImmutableProcessInstanceModificationVariableInstructionValue.Builder builder) {
    if (builder == null) return null;
    return builder.build();
  }

  
  private static ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(value).build();
  }

  
  private static ImmutableProcessInstanceModificationVariableInstructionValue.Builder convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue( ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue value) {
    if (value == null) return null;
    return ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(value);
  }

  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationVariableInstructionValue.Builder> builderList) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> list;
    if (builderList instanceof Collection<?>) {
      int size = ((Collection<?>) builderList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : builderList) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> convertToValueTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(ImmutableProcessInstanceModificationVariableInstructionValue.Builder... builderArray) {
    ArrayList<ProcessInstanceModificationRecordValue.ProcessInstanceModificationVariableInstructionValue> list;
    if (builderArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(builderArray.length);
    for (ImmutableProcessInstanceModificationVariableInstructionValue.Builder element : builderArray) {
      list.add(element.build());
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(Iterable<? extends ImmutableProcessInstanceModificationVariableInstructionValue> valueList) {
    ArrayList<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> list;
    if (valueList instanceof Collection<?>) {
      int size = ((Collection<?>) valueList).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>(size);
    } else {
      list = new ArrayList<>();
    }
    for (ImmutableProcessInstanceModificationVariableInstructionValue element : valueList) {
      list.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
    }
    return list;
  }

  private static List<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> convertToBuilderTypeio_camunda_zeebe_protocol_record_value_ImmutableProcessInstanceModificationVariableInstructionValue(ImmutableProcessInstanceModificationVariableInstructionValue... valueArray) {
    ArrayList<ImmutableProcessInstanceModificationVariableInstructionValue.Builder> list;
    if (valueArray.length == 0) return Collections.emptyList();
    list = new ArrayList<>(valueArray.length);
    for (ImmutableProcessInstanceModificationVariableInstructionValue element : valueArray) {
      list.add(ImmutableProcessInstanceModificationVariableInstructionValue.builder().from(element));
    }
    return list;
  }
}
