/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record;

import io.camunda.zeebe.protocol.record.ExecuteCommandRequestDecoder;
import io.camunda.zeebe.protocol.record.MessageHeaderEncoder;
import io.camunda.zeebe.protocol.record.MetaAttribute;
import io.camunda.zeebe.protocol.record.ValueType;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ExecuteCommandRequestEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 20;
    public static final int TEMPLATE_ID = 20;
    public static final int SCHEMA_ID = 0;
    public static final int SCHEMA_VERSION = 5;
    public static final String SEMANTIC_VERSION = "8.6.5";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ExecuteCommandRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 20;
    }

    public int sbeTemplateId() {
        return 20;
    }

    public int sbeSchemaId() {
        return 0;
    }

    public int sbeSchemaVersion() {
        return 5;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ExecuteCommandRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 20);
        return this;
    }

    public ExecuteCommandRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(20).templateId(20).schemaId(0).version(5);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public ExecuteCommandRequestEncoder partitionId(int value) {
        this.buffer.putShort(this.offset + 0, (short)value, BYTE_ORDER);
        return this;
    }

    public static int keyId() {
        return 4;
    }

    public static int keySinceVersion() {
        return 0;
    }

    public static int keyEncodingOffset() {
        return 2;
    }

    public static int keyEncodingLength() {
        return 8;
    }

    public static String keyMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long keyNullValue() {
        return -1L;
    }

    public static long keyMinValue() {
        return 0L;
    }

    public static long keyMaxValue() {
        return -2L;
    }

    public ExecuteCommandRequestEncoder key(long value) {
        this.buffer.putLong(this.offset + 2, value, BYTE_ORDER);
        return this;
    }

    public static int valueTypeId() {
        return 5;
    }

    public static int valueTypeSinceVersion() {
        return 0;
    }

    public static int valueTypeEncodingOffset() {
        return 10;
    }

    public static int valueTypeEncodingLength() {
        return 1;
    }

    public static String valueTypeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ExecuteCommandRequestEncoder valueType(ValueType value) {
        this.buffer.putByte(this.offset + 10, (byte)value.value());
        return this;
    }

    public static int intentId() {
        return 6;
    }

    public static int intentSinceVersion() {
        return 0;
    }

    public static int intentEncodingOffset() {
        return 11;
    }

    public static int intentEncodingLength() {
        return 1;
    }

    public static String intentMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static short intentNullValue() {
        return 255;
    }

    public static short intentMinValue() {
        return 0;
    }

    public static short intentMaxValue() {
        return 254;
    }

    public ExecuteCommandRequestEncoder intent(short value) {
        this.buffer.putByte(this.offset + 11, (byte)value);
        return this;
    }

    public static int operationReferenceId() {
        return 9;
    }

    public static int operationReferenceSinceVersion() {
        return 5;
    }

    public static int operationReferenceEncodingOffset() {
        return 12;
    }

    public static int operationReferenceEncodingLength() {
        return 8;
    }

    public static String operationReferenceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static long operationReferenceNullValue() {
        return -1L;
    }

    public static long operationReferenceMinValue() {
        return 0L;
    }

    public static long operationReferenceMaxValue() {
        return -2L;
    }

    public ExecuteCommandRequestEncoder operationReference(long value) {
        this.buffer.putLong(this.offset + 12, value, BYTE_ORDER);
        return this;
    }

    public static int valueId() {
        return 7;
    }

    public static String valueCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String valueMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int valueHeaderLength() {
        return 4;
    }

    public ExecuteCommandRequestEncoder putValue(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ExecuteCommandRequestEncoder putValue(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ExecuteCommandRequestEncoder value(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public static int authorizationId() {
        return 8;
    }

    public static String authorizationCharacterEncoding() {
        return StandardCharsets.UTF_8.name();
    }

    public static String authorizationMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int authorizationHeaderLength() {
        return 4;
    }

    public ExecuteCommandRequestEncoder putAuthorization(DirectBuffer src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ExecuteCommandRequestEncoder putAuthorization(byte[] src, int srcOffset, int length) {
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, src, srcOffset, length);
        return this;
    }

    public ExecuteCommandRequestEncoder authorization(String value) {
        byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
        int length = bytes.length;
        if (length > Integer.MAX_VALUE) {
            throw new IllegalStateException("length > maxValue for type: " + length);
        }
        int headerLength = 4;
        int limit = this.parentMessage.limit();
        this.parentMessage.limit(limit + 4 + length);
        this.buffer.putInt(limit, length, BYTE_ORDER);
        this.buffer.putBytes(limit + 4, bytes, 0, length);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ExecuteCommandRequestDecoder decoder = new ExecuteCommandRequestDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 20, 5);
        return decoder.appendTo(builder);
    }
}

