/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorJob;
import io.camunda.zeebe.scheduler.ActorSubscription;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ActorThreadGroup;
import io.camunda.zeebe.scheduler.ClosedQueue;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Loggers;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.agrona.concurrent.ManyToOneConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActorTask {
    private static final Logger LOG = LoggerFactory.getLogger(ActorTask.class);
    private static final AtomicReferenceFieldUpdater<ActorTask, ActorLifecyclePhase> LIFECYCLE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ActorTask.class, ActorLifecyclePhase.class, "lifecyclePhase");
    public final CompletableActorFuture<Void> closeFuture = new CompletableActorFuture();
    final Actor actor;
    ActorJob currentJob;
    boolean shouldYield;
    final AtomicReference<TaskSchedulingState> schedulingState = new AtomicReference();
    final AtomicLong stateCount = new AtomicLong(0L);
    private final CompletableActorFuture<Void> jobClosingTaskFuture = new CompletableActorFuture();
    private final CompletableActorFuture<Void> startingFuture = new CompletableActorFuture();
    private final CompletableActorFuture<Void> jobStartingTaskFuture = new CompletableActorFuture();
    private ActorThreadGroup actorThreadGroup;
    private Deque<ActorJob> fastLaneJobs = new ClosedQueue();
    private volatile ActorLifecyclePhase lifecyclePhase = ActorLifecyclePhase.CLOSED;
    private List<ActorSubscription> subscriptions = new ArrayList<ActorSubscription>();
    private volatile Queue<ActorJob> submittedJobs = new ClosedQueue();

    public ActorTask(Actor actor) {
        this.actor = actor;
    }

    public ActorFuture<Void> onTaskScheduled(ActorThreadGroup actorThreadGroup) {
        this.actorThreadGroup = actorThreadGroup;
        this.closeFuture.close();
        this.closeFuture.setAwaitingResult();
        this.jobClosingTaskFuture.close();
        this.jobClosingTaskFuture.setAwaitingResult();
        this.startingFuture.close();
        this.startingFuture.setAwaitingResult();
        this.jobStartingTaskFuture.close();
        this.jobStartingTaskFuture.setAwaitingResult();
        this.submittedJobs = new ManyToOneConcurrentLinkedQueue();
        this.fastLaneJobs = new ArrayDeque<ActorJob>();
        this.lifecyclePhase = ActorLifecyclePhase.STARTING;
        ActorJob j = new ActorJob();
        j.setRunnable(this.actor::onActorStarting);
        j.setResultFuture(this.jobStartingTaskFuture);
        j.onJobAddedToTask(this);
        this.currentJob = j;
        return this.startingFuture;
    }

    public void submit(ActorJob job) {
        Queue<ActorJob> submittedJobs = this.submittedJobs;
        if (submittedJobs.offer(job)) {
            if (submittedJobs != this.submittedJobs) {
                this.failJob(job);
            } else {
                this.tryWakeup();
            }
        } else {
            job.failFuture("Was not able to submit job to the actors queue.");
        }
    }

    public boolean execute(ActorThread runner) {
        this.schedulingState.set(TaskSchedulingState.ACTIVE);
        boolean resubmit = false;
        while (!resubmit && (this.currentJob != null || this.poll())) {
            this.currentJob.execute(runner);
            switch (this.currentJob.schedulingState) {
                case TERMINATED: {
                    ActorJob terminatedJob = this.currentJob;
                    this.currentJob = this.fastLaneJobs.poll();
                    if (terminatedJob.isTriggeredBySubscription()) {
                        ActorSubscription subscription = terminatedJob.getSubscription();
                        if (!subscription.isRecurring()) {
                            this.removeSubscription(subscription);
                        }
                        subscription.onJobCompleted();
                        break;
                    }
                    runner.recycleJob(terminatedJob);
                    break;
                }
                case QUEUED: {
                    resubmit = true;
                    break;
                }
            }
            if (!this.shouldYield) continue;
            this.shouldYield = false;
            boolean bl = resubmit = this.currentJob != null;
            break;
        }
        if (this.currentJob == null) {
            resubmit = this.onAllJobsDone();
        }
        return resubmit;
    }

    private boolean onAllJobsDone() {
        boolean resubmit;
        block10: {
            block9: {
                resubmit = false;
                if (!this.allPhaseSubscriptionsTriggered()) break block9;
                switch (this.lifecyclePhase) {
                    case STARTING: {
                        this.lifecyclePhase = ActorLifecyclePhase.STARTED;
                        this.submitStartedJob();
                        this.startingFuture.completeWith(this.jobStartingTaskFuture);
                        resubmit = true;
                        break block10;
                    }
                    case CLOSING: {
                        this.lifecyclePhase = ActorLifecyclePhase.CLOSED;
                        this.submitClosedJob();
                        resubmit = true;
                        break block10;
                    }
                    case STARTED: {
                        resubmit = this.tryWait();
                        break block10;
                    }
                    case CLOSE_REQUESTED: {
                        this.lifecyclePhase = ActorLifecyclePhase.CLOSING;
                        this.submitClosingJob();
                        resubmit = true;
                        break block10;
                    }
                    case CLOSED: {
                        this.onClosed();
                        this.closeFuture.completeWith(this.jobClosingTaskFuture);
                        resubmit = false;
                        break block10;
                    }
                    case FAILED: {
                        this.onClosed();
                        resubmit = false;
                        break block10;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected actor lifecycle phase " + this.lifecyclePhase.name());
                    }
                }
            }
            if (this.lifecyclePhase != ActorLifecyclePhase.CLOSED) {
                resubmit = this.tryWait();
            }
        }
        return resubmit;
    }

    private void submitStartedJob() {
        ActorJob startedJob = ActorThread.current().newJob();
        startedJob.onJobAddedToTask(this);
        startedJob.setRunnable(this.actor::onActorStarted);
        this.currentJob = startedJob;
    }

    private void submitClosedJob() {
        ActorJob closedJob = ActorThread.current().newJob();
        closedJob.onJobAddedToTask(this);
        closedJob.setRunnable(this.actor::onActorClosed);
        this.currentJob = closedJob;
    }

    private void submitClosingJob() {
        ActorJob closeJob = ActorThread.current().newJob();
        closeJob.onJobAddedToTask(this);
        closeJob.setRunnable(this.actor::onActorClosing);
        closeJob.setResultFuture(this.jobClosingTaskFuture);
        this.currentJob = closeJob;
    }

    private void onClosed() {
        ActorJob j;
        this.schedulingState.set(TaskSchedulingState.NOT_SCHEDULED);
        ArrayList<ActorSubscription> actorSubscriptions = new ArrayList<ActorSubscription>(this.subscriptions);
        actorSubscriptions.forEach(ActorSubscription::cancel);
        this.subscriptions = new ArrayList<ActorSubscription>();
        Queue<ActorJob> activeJobsQueue = this.submittedJobs;
        this.submittedJobs = new ClosedQueue();
        while ((j = activeJobsQueue.poll()) != null) {
            this.failJob(j);
        }
    }

    private void failJob(ActorJob job) {
        try {
            job.failFuture("Actor is closed");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void requestClose() {
        if (this.lifecyclePhase == ActorLifecyclePhase.STARTED) {
            this.lifecyclePhase = ActorLifecyclePhase.CLOSE_REQUESTED;
            this.discardNextJobs();
            this.actor.onActorCloseRequested();
        }
    }

    public void onFailure(Throwable failure) {
        ActorLifecyclePhase currentPhase = this.lifecyclePhase;
        switch (currentPhase) {
            case STARTING: {
                Loggers.ACTOR_LOGGER.error("Actor failed in phase 'STARTING'. Discard all jobs and stop immediately.", failure);
                this.lifecyclePhase = ActorLifecyclePhase.FAILED;
                this.discardNextJobs();
                this.startingFuture.completeExceptionally(failure);
                this.closeFuture.completeExceptionally(failure);
                break;
            }
            case CLOSING: 
            case CLOSE_REQUESTED: {
                Loggers.ACTOR_LOGGER.error("Actor failed in phase '{}'. Discard all jobs and stop immediately.", (Object)currentPhase, (Object)failure);
                this.lifecyclePhase = ActorLifecyclePhase.FAILED;
                this.discardNextJobs();
                this.closeFuture.completeExceptionally(failure);
                break;
            }
            case STARTED: {
                this.actor.handleFailure(failure);
                this.currentJob.failFuture(failure);
                break;
            }
        }
    }

    private void discardNextJobs() {
        ActorJob next;
        while ((next = this.fastLaneJobs.poll()) != null) {
            LOG.debug("Discard job {} from fastLane of Actor {}.", (Object)next, (Object)this.actor.getName());
            this.failJob(next);
        }
    }

    boolean casStateCount(long expectedCount) {
        return this.stateCount.compareAndSet(expectedCount, expectedCount + 1L);
    }

    boolean casState(TaskSchedulingState expectedState, TaskSchedulingState newState) {
        return this.schedulingState.compareAndSet(expectedState, newState);
    }

    public boolean claim(long stateCount) {
        return this.casStateCount(stateCount);
    }

    boolean tryWait() {
        ArrayList<ActorSubscription> subscriptionsRef = new ArrayList<ActorSubscription>(this.subscriptions);
        this.schedulingState.set(TaskSchedulingState.WAITING);
        if (this.lifecyclePhase == ActorLifecyclePhase.STARTED && !this.submittedJobs.isEmpty() || this.pollSubscriptionsWithoutAddingJobs(subscriptionsRef)) {
            return this.casState(TaskSchedulingState.WAITING, TaskSchedulingState.WAKING_UP);
        }
        return false;
    }

    public boolean tryWakeup() {
        boolean didWakeup = false;
        if (this.casState(TaskSchedulingState.WAITING, TaskSchedulingState.WAKING_UP)) {
            this.resubmit();
            didWakeup = true;
        }
        return didWakeup;
    }

    private boolean poll() {
        boolean result = false;
        result |= this.pollSubmittedJobs();
        return result |= this.pollSubscriptions();
    }

    private boolean pollSubscriptions() {
        boolean hasJobs = false;
        for (ActorSubscription subscription : this.subscriptions) {
            if (!this.pollSubscription(subscription)) continue;
            ActorJob job = subscription.getJob();
            job.schedulingState = TaskSchedulingState.QUEUED;
            if (this.currentJob == null) {
                this.currentJob = job;
            } else {
                this.fastLaneJobs.offer(job);
            }
            hasJobs = true;
        }
        return hasJobs;
    }

    private boolean pollSubscription(ActorSubscription subscription) {
        return subscription.triggersInPhase(this.lifecyclePhase) && subscription.poll();
    }

    private boolean pollSubscriptionsWithoutAddingJobs(List<ActorSubscription> subscriptions) {
        boolean result = false;
        for (int i = 0; i < subscriptions.size() && !result; result |= this.pollSubscription(subscriptions.get(i)), ++i) {
        }
        return result;
    }

    private boolean allPhaseSubscriptionsTriggered() {
        ActorSubscription subscription;
        boolean allTriggered = true;
        for (int i = 0; i < this.subscriptions.size() && allTriggered; allTriggered &= !(subscription = this.subscriptions.get(i)).triggersInPhase(this.lifecyclePhase), ++i) {
        }
        return allTriggered;
    }

    private boolean pollSubmittedJobs() {
        boolean hasJobs = false;
        while (this.lifecyclePhase == ActorLifecyclePhase.STARTED && !this.submittedJobs.isEmpty()) {
            ActorJob job = this.submittedJobs.poll();
            if (job == null) continue;
            if (this.currentJob == null) {
                this.currentJob = job;
            } else {
                this.fastLaneJobs.offer(job);
            }
            hasJobs = true;
        }
        return hasJobs;
    }

    public TaskSchedulingState getState() {
        return this.schedulingState.get();
    }

    public String toString() {
        return this.actor.getName() + " " + (Object)((Object)this.schedulingState.get()) + " phase: " + this.lifecyclePhase;
    }

    public void yieldThread() {
        this.shouldYield = true;
    }

    public long getStateCount() {
        return this.stateCount.get();
    }

    public String getName() {
        return this.actor.getName();
    }

    public Actor getActor() {
        return this.actor;
    }

    public boolean isClosing() {
        return this.lifecyclePhase == ActorLifecyclePhase.CLOSING;
    }

    public ActorLifecyclePhase getLifecyclePhase() {
        return this.lifecyclePhase;
    }

    public CompletableActorFuture<Void> getStartingFuture() {
        return this.startingFuture;
    }

    public void addSubscription(ActorSubscription subscription) {
        ActorThread.ensureCalledFromActorThread("addSubscription(ActorSubscription)");
        this.subscriptions.add(subscription);
    }

    private void removeSubscription(ActorSubscription subscription) {
        ActorThread.ensureCalledFromActorThread("removeSubscription(ActorSubscription)");
        this.subscriptions.remove(subscription);
    }

    public void onSubscriptionCancelled(ActorSubscription subscription) {
        if (this.lifecyclePhase != ActorLifecyclePhase.CLOSED) {
            this.removeSubscription(subscription);
        }
    }

    public void resubmit() {
        this.actorThreadGroup.submit(this);
    }

    public void insertJob(ActorJob job) {
        this.fastLaneJobs.addFirst(job);
    }

    public void fail(Throwable error) {
        ActorLifecyclePhase previousPhase = LIFECYCLE_UPDATER.getAndSet(this, ActorLifecyclePhase.FAILED);
        if (previousPhase == ActorLifecyclePhase.FAILED) {
            return;
        }
        if (previousPhase == ActorLifecyclePhase.STARTING) {
            this.startingFuture.completeExceptionally(error);
        }
        if (previousPhase != ActorLifecyclePhase.CLOSED) {
            this.closeFuture.completeExceptionally(error);
        }
        this.discardNextJobs();
        this.actor.onActorFailed();
    }

    public int estimateQueueLength() {
        if (this.fastLaneJobs instanceof ClosedQueue || this.submittedJobs instanceof ClosedQueue) {
            return 0;
        }
        return this.fastLaneJobs.size() + this.submittedJobs.size();
    }

    public static enum ActorLifecyclePhase {
        STARTING(1),
        STARTED(2),
        CLOSE_REQUESTED(4),
        CLOSING(8),
        CLOSED(16),
        FAILED(32);

        private final int value;

        private ActorLifecyclePhase(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum TaskSchedulingState {
        NOT_SCHEDULED,
        ACTIVE,
        QUEUED,
        WAITING,
        WAKING_UP,
        TERMINATED;

    }
}

