/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorFutureSubscription;
import io.camunda.zeebe.scheduler.ActorMetrics;
import io.camunda.zeebe.scheduler.ActorSubscription;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.TimerSubscription;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.util.Loggers;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import java.util.concurrent.Callable;
import org.jetbrains.annotations.Async;
import org.slf4j.Logger;

public final class ActorJob {
    private static final Logger LOG = Loggers.ACTOR_LOGGER;
    private static final FatalErrorHandler FATAL_ERROR_HANDLER = FatalErrorHandler.withLogger((Logger)LOG);
    ActorTask.TaskSchedulingState schedulingState;
    Actor actor;
    ActorTask task;
    ActorThread actorThread;
    private Callable<?> callable;
    private Runnable runnable;
    private Object invocationResult;
    private ActorFuture resultFuture;
    private ActorSubscription subscription;
    private long scheduledAt = -1L;

    public void onJobAddedToTask(ActorTask task) {
        this.scheduledAt = System.nanoTime();
        this.actor = task.actor;
        this.task = task;
        this.schedulingState = ActorTask.TaskSchedulingState.QUEUED;
    }

    @Async.Execute
    void execute(ActorThread runner) {
        this.actorThread = runner;
        this.observeSchedulingLatency(runner.getActorMetrics());
        try {
            this.invoke();
            if (this.resultFuture != null) {
                this.resultFuture.complete(this.invocationResult);
                this.resultFuture = null;
            }
        }
        catch (Throwable e) {
            FATAL_ERROR_HANDLER.handleError(e);
            this.task.onFailure(e);
        }
        finally {
            this.actorThread = null;
            if (this.isTriggeredBySubscription() || this.runnable == null) {
                this.schedulingState = ActorTask.TaskSchedulingState.TERMINATED;
            } else {
                this.schedulingState = ActorTask.TaskSchedulingState.QUEUED;
                this.scheduledAt = System.nanoTime();
            }
        }
    }

    private void observeSchedulingLatency(ActorMetrics metrics) {
        if (metrics.isEnabled()) {
            ActorFutureSubscription s;
            long now = System.nanoTime();
            Object object = this.subscription;
            if (object instanceof ActorFutureSubscription && (object = (s = (ActorFutureSubscription)object).getFuture()) instanceof CompletableActorFuture) {
                CompletableActorFuture f = (CompletableActorFuture)object;
                long subscriptionCompleted = f.getCompletedAt();
                metrics.observeJobSchedulingLatency(now - subscriptionCompleted, "Future");
            } else {
                ActorSubscription subscriptionCompleted = this.subscription;
                if (subscriptionCompleted instanceof TimerSubscription) {
                    TimerSubscription s2 = (TimerSubscription)subscriptionCompleted;
                    long timerExpired = s2.getTimerExpiredAt();
                    metrics.observeJobSchedulingLatency(now - timerExpired, "Timer");
                } else if (this.subscription == null && this.scheduledAt != -1L) {
                    metrics.observeJobSchedulingLatency(now - this.scheduledAt, "None");
                }
            }
        }
    }

    private void invoke() throws Exception {
        if (this.callable != null) {
            this.invocationResult = this.callable.call();
        } else if (!this.isTriggeredBySubscription()) {
            Runnable r = this.runnable;
            this.runnable = null;
            r.run();
        } else {
            this.runnable.run();
        }
    }

    public void setRunnable(Runnable runnable) {
        this.runnable = runnable;
    }

    public ActorFuture setCallable(Callable<?> callable) {
        this.callable = callable;
        this.setResultFuture(new CompletableActorFuture());
        return this.resultFuture;
    }

    void reset() {
        this.schedulingState = ActorTask.TaskSchedulingState.NOT_SCHEDULED;
        this.scheduledAt = -1L;
        this.actor = null;
        this.task = null;
        this.actorThread = null;
        this.callable = null;
        this.runnable = null;
        this.invocationResult = null;
        this.resultFuture = null;
        this.subscription = null;
    }

    public String toString() {
        Object toString = "";
        if (this.runnable != null) {
            toString = (String)toString + this.runnable.getClass().getName();
        }
        if (this.callable != null) {
            toString = (String)toString + this.callable.getClass().getName();
        }
        toString = (String)toString + " " + String.valueOf((Object)this.schedulingState);
        return toString;
    }

    public boolean isTriggeredBySubscription() {
        return this.subscription != null;
    }

    public ActorSubscription getSubscription() {
        return this.subscription;
    }

    public void setSubscription(ActorSubscription subscription) {
        this.subscription = subscription;
        this.task.addSubscription(subscription);
    }

    public ActorTask getTask() {
        return this.task;
    }

    public Actor getActor() {
        return this.actor;
    }

    public void setResultFuture(ActorFuture resultFuture) {
        assert (!resultFuture.isDone());
        this.resultFuture = resultFuture;
    }

    public void failFuture(String reason) {
        this.failFuture(new RuntimeException(reason));
    }

    public void failFuture(Throwable cause) {
        if (this.resultFuture != null) {
            this.resultFuture.completeExceptionally(cause);
        }
    }
}

