/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler.clock;

import io.camunda.zeebe.scheduler.clock.ActorClock;
import java.time.Duration;
import java.time.Instant;

public final class ControlledActorClock
implements ActorClock {
    private volatile long currentTime;
    private volatile long currentOffset;
    private volatile long updatedTime;

    public ControlledActorClock() {
        this.reset();
    }

    public void pinCurrentTime() {
        this.setCurrentTime(this.getCurrentTime());
    }

    public void addTime(Duration durationToAdd) {
        if (this.usesPointInTime()) {
            this.currentTime += durationToAdd.toMillis();
        } else {
            this.currentOffset += durationToAdd.toMillis();
        }
    }

    public void reset() {
        this.currentTime = -1L;
        this.currentOffset = 0L;
        this.updatedTime = System.currentTimeMillis();
    }

    public Instant getCurrentTime() {
        return Instant.ofEpochMilli(this.getTimeMillis());
    }

    public void setCurrentTime(long currentTime) {
        this.currentTime = currentTime;
    }

    public void setCurrentTime(Instant currentTime) {
        this.currentTime = currentTime.toEpochMilli();
    }

    private boolean usesPointInTime() {
        return this.currentTime > 0L;
    }

    @Override
    public boolean update() {
        this.updatedTime = this.usesPointInTime() ? this.currentTime : System.currentTimeMillis() + this.currentOffset;
        return true;
    }

    @Override
    public long getTimeMillis() {
        return this.updatedTime;
    }

    @Override
    public long getNanosSinceLastMillisecond() {
        return 0L;
    }

    @Override
    public long getNanoTime() {
        return 0L;
    }

    public long getCurrentTimeInMillis() {
        return this.getTimeMillis();
    }
}

