/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.SnapshotId;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileBasedSnapshotId
implements SnapshotId {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileBasedSnapshotId.class);
    private static final int SNAPSHOT_ID_PARTS = 4;
    private final long index;
    private final long term;
    private final long processedPosition;
    private final long exporterPosition;

    FileBasedSnapshotId(long index, long term, long processedPosition, long exporterPosition) {
        this.index = index;
        this.term = term;
        this.processedPosition = processedPosition;
        this.exporterPosition = exporterPosition;
    }

    public static Optional<FileBasedSnapshotId> ofPath(Path path) {
        return FileBasedSnapshotId.ofFileName(path.getFileName().toString());
    }

    public static Optional<FileBasedSnapshotId> ofFileName(String name) {
        String[] parts = name.split("-");
        Optional<FileBasedSnapshotId> snapshotId = Optional.empty();
        if (parts.length >= 4) {
            try {
                long index = Long.parseLong(parts[0]);
                long term = Long.parseLong(parts[1]);
                long processedPosition = Long.parseLong(parts[2]);
                long exporterPosition = Long.parseLong(parts[3]);
                snapshotId = Optional.of(new FileBasedSnapshotId(index, term, processedPosition, exporterPosition));
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Failed to parse part of snapshot id", (Throwable)e);
            }
        } else {
            LOGGER.warn("Expected snapshot file format to be %d-%d-%d-%d, but was {}", (Object)name);
        }
        return snapshotId;
    }

    @Override
    public long getIndex() {
        return this.index;
    }

    @Override
    public long getTerm() {
        return this.term;
    }

    @Override
    public long getProcessedPosition() {
        return this.processedPosition;
    }

    @Override
    public long getExportedPosition() {
        return this.exporterPosition;
    }

    @Override
    public String getSnapshotIdAsString() {
        return String.format("%d-%d-%d-%d", this.getIndex(), this.getTerm(), this.getProcessedPosition(), this.getExportedPosition());
    }

    public int hashCode() {
        return Objects.hash(this.index, this.term, this.processedPosition, this.exporterPosition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileBasedSnapshotId that = (FileBasedSnapshotId)o;
        return this.index == that.index && this.term == that.term && this.processedPosition == that.processedPosition && this.exporterPosition == that.exporterPosition;
    }

    public String toString() {
        return "FileBasedSnapshotId{index=" + this.index + ", term=" + this.term + ", processedPosition=" + this.processedPosition + ", exporterPosition=" + this.exporterPosition + "}";
    }
}

