/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.snapshots.impl;

import io.camunda.zeebe.snapshots.SnapshotChunk;
import java.util.zip.CRC32C;
import java.util.zip.Checksum;

final class SnapshotChunkUtil {
    private SnapshotChunkUtil() {
    }

    static long createChecksum(byte[] content) {
        Checksum checksum = SnapshotChunkUtil.newChecksum();
        checksum.update(content);
        return checksum.getValue();
    }

    static Checksum newChecksum() {
        return new CRC32C();
    }

    static SnapshotChunk createSnapshotChunkFromFileChunk(String snapshotId, int totalCount, String fileName, byte[] fileData, long fileBlockPosition, long totalFileSize) {
        long checksum = SnapshotChunkUtil.createChecksum(fileData);
        return new SnapshotChunkImpl(snapshotId, totalCount, fileName, checksum, fileData, fileBlockPosition, totalFileSize);
    }

    private static final class SnapshotChunkImpl
    implements SnapshotChunk {
        private final String snapshotId;
        private final int totalCount;
        private final String chunkName;
        private final byte[] content;
        private final long checksum;
        private final long fileBlockPosition;
        private final long totalFileSize;

        SnapshotChunkImpl(String snapshotId, int totalCount, String chunkName, long checksum, byte[] content, long fileBlockPosition, long totalFileSize) {
            this.snapshotId = snapshotId;
            this.totalCount = totalCount;
            this.chunkName = chunkName;
            this.checksum = checksum;
            this.content = content;
            this.fileBlockPosition = fileBlockPosition;
            this.totalFileSize = totalFileSize;
        }

        @Override
        public String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public int getTotalCount() {
            return this.totalCount;
        }

        @Override
        public String getChunkName() {
            return this.chunkName;
        }

        @Override
        public long getChecksum() {
            return this.checksum;
        }

        @Override
        public byte[] getContent() {
            return this.content;
        }

        @Override
        public long getFileBlockPosition() {
            return this.fileBlockPosition;
        }

        @Override
        public long getTotalFileSize() {
            return this.totalFileSize;
        }
    }
}

