/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.Objects;
import org.agrona.DirectBuffer;

public final class EnsureUtil {
    private static final String ERROR_MSG_NON_EMPTY = "%s must not be empty";

    private EnsureUtil() {
    }

    public static void ensureNotNull(String property, Object o) {
        Objects.requireNonNull(o, property);
    }

    public static long ensureGreaterThan(String property, long testValue, long comparisonValue) {
        if (testValue <= comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than " + comparisonValue);
        }
        return testValue;
    }

    public static void ensureGreaterThanOrEqual(String property, long testValue, long comparisonValue) {
        if (testValue < comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than or equal to " + comparisonValue);
        }
    }

    public static void ensureGreaterThan(String property, double testValue, double comparisonValue) {
        if (testValue <= comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than " + comparisonValue);
        }
    }

    public static void ensureGreaterThanOrEqual(String property, double testValue, double comparisonValue) {
        if (testValue < comparisonValue) {
            throw new IllegalArgumentException(property + " must be greater than or equal to " + comparisonValue);
        }
    }

    public static void ensureNotNullOrEmpty(String property, String testValue) {
        EnsureUtil.ensureNotNull(property, testValue);
        if (testValue.isEmpty()) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_NON_EMPTY, property));
        }
    }

    public static void ensureNotNullOrEmpty(String property, byte[] testValue) {
        EnsureUtil.ensureNotNull(property, testValue);
        if (testValue.length == 0) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_NON_EMPTY, property));
        }
    }

    public static void ensureNotNullOrEmpty(String property, DirectBuffer testValue) {
        EnsureUtil.ensureNotNull(property, testValue);
        if (testValue.capacity() == 0) {
            throw new IllegalArgumentException(String.format(ERROR_MSG_NON_EMPTY, property));
        }
    }
}

