/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.concurrent.locks.Lock;
import java.util.function.Supplier;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;

public final class LockUtil {
    private static final ErrorHandler IGNORE_ERROR_HANDLER = error -> {};

    private LockUtil() {
    }

    public static void withLock(Lock lock, Runnable runnable) {
        LockUtil.withLock(lock, runnable, IGNORE_ERROR_HANDLER);
    }

    public static <V> V withLock(Lock lock, Supplier<V> callable) {
        return LockUtil.withLock(lock, callable, IGNORE_ERROR_HANDLER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLock(Lock lock, Runnable runnable, ErrorHandler errorHandler) {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            errorHandler.onError((Throwable)e);
            LangUtil.rethrowUnchecked((Throwable)e);
            return;
        }
        try {
            runnable.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V withLock(Lock lock, Supplier<V> callable, ErrorHandler errorHandler) {
        try {
            lock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            errorHandler.onError((Throwable)e);
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
        try {
            V v = callable.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }
}

