/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.Comparator;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public final class StreamUtil {
    private StreamUtil() {
    }

    public static <T> Collector<T, MinMaxCollector.MinMax<T>, MinMaxCollector.MinMax<T>> minMax(Comparator<T> comparator) {
        return new MinMaxCollector<T>(comparator);
    }

    static final class MinMaxCollector<T>
    implements Collector<T, MinMax<T>, MinMax<T>> {
        private final Comparator<T> comparator;

        private MinMaxCollector(Comparator<T> comparator) {
            this.comparator = comparator;
        }

        @Override
        public Supplier<MinMax<T>> supplier() {
            return MinMax::new;
        }

        @Override
        public BiConsumer<MinMax<T>, T> accumulator() {
            return (minMax, value) -> {
                if (minMax.min == null || this.comparator.compare(value, minMax.min) < 0) {
                    minMax.min = value;
                }
                if (minMax.max == null || this.comparator.compare(value, minMax.max) > 0) {
                    minMax.max = value;
                }
            };
        }

        @Override
        public BinaryOperator<MinMax<T>> combiner() {
            return (minMax1, minMax2) -> {
                if (this.comparator.compare(minMax1.min, minMax2.min) < 0) {
                    minMax1.min = minMax2.min;
                }
                if (this.comparator.compare(minMax1.max, minMax2.max) > 0) {
                    minMax1.max = minMax2.max;
                }
                return minMax1;
            };
        }

        @Override
        public Function<MinMax<T>, MinMax<T>> finisher() {
            return minMax -> minMax;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Set.of(Collector.Characteristics.IDENTITY_FINISH);
        }

        public static final class MinMax<T> {
            private T min;
            private T max;

            public T min() {
                return this.min;
            }

            public T max() {
                return this.max;
            }
        }
    }
}

