/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.deployment;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.deployment.PersistedForm;
import io.camunda.zeebe.engine.state.deployment.VersionManager;
import io.camunda.zeebe.engine.state.mutable.MutableFormState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.deployment.FormRecord;
import java.util.Optional;
import org.agrona.DirectBuffer;

public class DbFormState
implements MutableFormState {
    private static final int DEFAULT_VERSION_VALUE = 0;
    private final DbString tenantIdKey = new DbString();
    private final DbLong dbFormKey = new DbLong();
    private final DbTenantAwareKey<DbLong> tenantAwareFormKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbFormKey, DbTenantAwareKey.PlacementType.PREFIX);
    private final PersistedForm dbPersistedForm = new PersistedForm();
    private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedForm> formsByKey;
    private final DbString dbFormId;
    private final VersionManager versionManager;
    private final DbLong formVersion;
    private final DbCompositeKey<DbString, DbLong> idAndVersionKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbLong>> tenantAwareIdAndVersionKey;
    private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbLong>>, PersistedForm> formByIdAndVersionColumnFamily;

    public DbFormState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.formsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.FORMS, transactionContext, this.tenantAwareFormKey, (DbValue)this.dbPersistedForm);
        this.dbFormId = new DbString();
        this.formVersion = new DbLong();
        this.idAndVersionKey = new DbCompositeKey((DbKey)this.dbFormId, (DbKey)this.formVersion);
        this.tenantAwareIdAndVersionKey = new DbTenantAwareKey(this.tenantIdKey, this.idAndVersionKey, DbTenantAwareKey.PlacementType.PREFIX);
        this.formByIdAndVersionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.FORM_BY_ID_AND_VERSION, transactionContext, this.tenantAwareIdAndVersionKey, (DbValue)this.dbPersistedForm);
        this.versionManager = new VersionManager(0L, zeebeDb, ZbColumnFamilies.FORM_VERSION, transactionContext);
    }

    @Override
    public void storeFormRecord(FormRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.dbFormKey.wrapLong(record.getFormKey());
        this.dbFormId.wrapString(record.getFormId());
        this.formVersion.wrapLong((long)record.getVersion());
        this.dbPersistedForm.wrap(record);
        this.formsByKey.upsert(this.tenantAwareFormKey, (DbValue)this.dbPersistedForm);
        this.formByIdAndVersionColumnFamily.upsert(this.tenantAwareIdAndVersionKey, (DbValue)this.dbPersistedForm);
        this.updateLatestVersion(record);
    }

    @Override
    public Optional<PersistedForm> findLatestFormById(DirectBuffer formId, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbFormId.wrapBuffer(formId);
        long latestVersion = this.versionManager.getLatestResourceVersion(formId, tenantId);
        this.formVersion.wrapLong(latestVersion);
        return Optional.ofNullable((PersistedForm)this.formByIdAndVersionColumnFamily.get(this.tenantAwareIdAndVersionKey)).map(PersistedForm::copy);
    }

    @Override
    public Optional<PersistedForm> findFormByKey(long formKey, String tenantId) {
        this.tenantIdKey.wrapString(tenantId);
        this.dbFormKey.wrapLong(formKey);
        return Optional.ofNullable((PersistedForm)this.formsByKey.get(this.tenantAwareFormKey)).map(PersistedForm::copy);
    }

    private void updateLatestVersion(FormRecord formRecord) {
        String formId = formRecord.getFormId();
        int version = formRecord.getVersion();
        String tenantId = formRecord.getTenantId();
        this.versionManager.addResourceVersion(formId, version, tenantId);
    }
}

