/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.instance;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.value.BaseValue;
import io.camunda.zeebe.msgpack.value.StringValue;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class EventScopeInstance
extends UnpackedObject
implements DbValue {
    private final BooleanProperty acceptingProp = new BooleanProperty("accepting");
    private final BooleanProperty interruptedProp = new BooleanProperty("interrupted", false);
    private final ArrayProperty<StringValue> interruptingElementIdsProp = new ArrayProperty("interrupting", (BaseValue)new StringValue());
    private final ArrayProperty<StringValue> boundaryElementIdsProp = new ArrayProperty("boundaryElementIds", (BaseValue)new StringValue());

    public EventScopeInstance() {
        this.declareProperty((BaseProperty)this.acceptingProp).declareProperty(this.interruptingElementIdsProp).declareProperty(this.boundaryElementIdsProp).declareProperty((BaseProperty)this.interruptedProp);
    }

    public EventScopeInstance(EventScopeInstance other) {
        this();
        int length = other.getLength();
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[length]);
        other.write((MutableDirectBuffer)buffer, 0);
        this.wrap((DirectBuffer)buffer, 0, length);
    }

    public boolean isAccepting() {
        return this.acceptingProp.getValue();
    }

    public EventScopeInstance setAccepting(boolean accepting) {
        this.acceptingProp.setValue(accepting);
        return this;
    }

    public boolean isInterrupted() {
        return this.interruptedProp.getValue();
    }

    public EventScopeInstance setInterrupted(boolean interrupted) {
        this.interruptedProp.setValue(interrupted);
        return this;
    }

    public EventScopeInstance addInterruptingElementId(DirectBuffer elementId) {
        ((StringValue)this.interruptingElementIdsProp.add()).wrap(elementId);
        return this;
    }

    public EventScopeInstance addBoundaryElementId(DirectBuffer elementId) {
        ((StringValue)this.boundaryElementIdsProp.add()).wrap(elementId);
        return this;
    }

    public boolean isInterruptingElementId(DirectBuffer elementId) {
        for (StringValue interruptingElementId : this.interruptingElementIdsProp) {
            if (!interruptingElementId.getValue().equals(elementId)) continue;
            return true;
        }
        return false;
    }

    public boolean isBoundaryElementId(DirectBuffer elementId) {
        for (StringValue boundaryElementId : this.boundaryElementIdsProp) {
            if (!boundaryElementId.getValue().equals(elementId)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.acceptingProp, this.interruptingElementIdsProp, this.boundaryElementIdsProp, this.interruptedProp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventScopeInstance)) {
            return false;
        }
        EventScopeInstance that = (EventScopeInstance)((Object)o);
        return Objects.equals(this.acceptingProp, that.acceptingProp) && Objects.equals(this.interruptingElementIdsProp, that.interruptingElementIdsProp) && Objects.equals(this.boundaryElementIdsProp, that.boundaryElementIdsProp) && Objects.equals(this.interruptedProp, that.interruptedProp);
    }
}

