/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.migration.to_8_3.legacy.LegacyDecisionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;

public class DbDecisionMigrationState {
    private final LegacyDecisionState from;
    private final DbDecisionState to;

    public DbDecisionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        EngineConfiguration config = new EngineConfiguration();
        this.from = new LegacyDecisionState(zeebeDb, transactionContext, config);
        this.to = new DbDecisionState(zeebeDb, transactionContext);
    }

    public void migrateDecisionStateForMultiTenancy() {
        this.to.tenantIdKey.wrapString("<default>");
        this.from.getDecisionsByKey().forEach((key, value) -> {
            value.setTenantId("<default>");
            this.to.dbDecisionKey.wrapLong(key.getValue());
            this.to.decisionsByKey.insert(this.to.tenantAwareDecisionKey, (DbValue)value);
            this.from.getDecisionsByKey().deleteExisting((DbKey)key);
        });
        this.from.getDecisionRequirementsByKey().forEach((key, value) -> {
            value.setTenantId("<default>");
            this.to.dbDecisionRequirementsKey.wrapLong(key.getValue());
            this.to.decisionRequirementsByKey.insert(this.to.tenantAwareDecisionRequirementsKey, (DbValue)value);
            this.from.getDecisionRequirementsByKey().deleteExisting((DbKey)key);
        });
        this.from.getLatestDecisionKeysByDecisionId().forEach((key, value) -> {
            this.to.dbDecisionId.wrapBuffer(key.getBuffer());
            this.to.dbDecisionKey.wrapLong(((DbLong)value.inner()).getValue());
            this.to.latestDecisionKeysByDecisionId.insert(this.to.tenantAwareDecisionId, this.to.fkDecision);
            this.from.getLatestDecisionKeysByDecisionId().deleteExisting((DbKey)key);
        });
        this.from.getLatestDecisionRequirementsKeysById().forEach((key, value) -> {
            this.to.dbDecisionRequirementsId.wrapBuffer(key.getBuffer());
            this.to.dbDecisionRequirementsKey.wrapLong(((DbLong)value.inner()).getValue());
            this.to.latestDecisionRequirementsKeysById.insert(this.to.tenantAwareDecisionRequirementsId, this.to.fkDecisionRequirements);
            this.from.getLatestDecisionRequirementsKeysById().deleteExisting((DbKey)key);
        });
        this.from.getDecisionKeyByDecisionRequirementsKey().forEach((key, value) -> {
            this.to.dbDecisionRequirementsKey.wrapLong(((DbLong)((DbForeignKey)key.first()).inner()).getValue());
            this.to.dbDecisionKey.wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            this.to.decisionKeyByDecisionRequirementsKey.insert(this.to.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
            this.from.getDecisionKeyByDecisionRequirementsKey().deleteExisting((DbKey)key);
        });
        this.from.getDecisionKeyByDecisionIdAndVersion().forEach((key, value) -> {
            this.to.dbDecisionId.wrapBuffer(((DbString)key.first()).getBuffer());
            this.to.dbDecisionVersion.wrapInt(((DbInt)key.second()).getValue());
            this.to.dbDecisionKey.wrapLong(((DbLong)value.inner()).getValue());
            this.to.decisionKeyByDecisionIdAndVersion.insert(this.to.tenantAwareDecisionIdAndVersion, this.to.fkDecision);
            this.from.getDecisionKeyByDecisionIdAndVersion().deleteExisting((DbKey)key);
        });
        this.from.getDecisionRequirementsKeyByIdAndVersion().forEach((key, value) -> {
            this.to.dbDecisionRequirementsId.wrapBuffer(((DbString)key.first()).getBuffer());
            this.to.dbDecisionRequirementsVersion.wrapInt(((DbInt)key.second()).getValue());
            this.to.dbDecisionRequirementsKey.wrapLong(((DbLong)value.inner()).getValue());
            this.to.decisionRequirementsKeyByIdAndVersion.insert(this.to.tenantAwareDecisionRequirementsIdAndVersion, this.to.fkDecisionRequirements);
            this.from.getDecisionRequirementsKeyByIdAndVersion().deleteExisting((DbKey)key);
        });
    }

    private static final class DbDecisionState {
        private final DbString tenantIdKey = new DbString();
        private final DbLong dbDecisionKey = new DbLong();
        private final DbTenantAwareKey<DbLong> tenantAwareDecisionKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionKey, DbTenantAwareKey.PlacementType.PREFIX);
        private final DbForeignKey<DbTenantAwareKey<DbLong>> fkDecision = new DbForeignKey(this.tenantAwareDecisionKey, (Enum)ZbColumnFamilies.DMN_DECISIONS);
        private final PersistedDecision dbPersistedDecision = new PersistedDecision();
        private final DbString dbDecisionId;
        private final DbTenantAwareKey<DbString> tenantAwareDecisionId;
        private final DbLong dbDecisionRequirementsKey;
        private final DbTenantAwareKey<DbLong> tenantAwareDecisionRequirementsKey;
        private final DbForeignKey<DbTenantAwareKey<DbLong>> fkDecisionRequirements;
        private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
        private final DbString dbDecisionRequirementsId;
        private final DbTenantAwareKey<DbString> tenantAwareDecisionRequirementsId;
        private final DbCompositeKey<DbForeignKey<DbTenantAwareKey<DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>> dbDecisionRequirementsKeyAndDecisionKey;
        private final ColumnFamily<DbCompositeKey<DbForeignKey<DbTenantAwareKey<DbLong>>, DbForeignKey<DbTenantAwareKey<DbLong>>>, DbNil> decisionKeyByDecisionRequirementsKey;
        private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedDecision> decisionsByKey;
        private final ColumnFamily<DbTenantAwareKey<DbString>, DbForeignKey<DbTenantAwareKey<DbLong>>> latestDecisionKeysByDecisionId;
        private final DbInt dbDecisionVersion;
        private final DbCompositeKey<DbString, DbInt> decisionIdAndVersion;
        private final DbTenantAwareKey<DbCompositeKey<DbString, DbInt>> tenantAwareDecisionIdAndVersion;
        private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbInt>>, DbForeignKey<DbTenantAwareKey<DbLong>>> decisionKeyByDecisionIdAndVersion;
        private final ColumnFamily<DbTenantAwareKey<DbLong>, PersistedDecisionRequirements> decisionRequirementsByKey;
        private final ColumnFamily<DbTenantAwareKey<DbString>, DbForeignKey<DbTenantAwareKey<DbLong>>> latestDecisionRequirementsKeysById;
        private final DbInt dbDecisionRequirementsVersion;
        private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
        private final DbTenantAwareKey<DbCompositeKey<DbString, DbInt>> tenantAwareDecisionRequirementsIdAndVersion;
        private final ColumnFamily<DbTenantAwareKey<DbCompositeKey<DbString, DbInt>>, DbForeignKey<DbTenantAwareKey<DbLong>>> decisionRequirementsKeyByIdAndVersion;

        public DbDecisionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.decisionsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISIONS, transactionContext, this.tenantAwareDecisionKey, (DbValue)this.dbPersistedDecision);
            this.dbDecisionId = new DbString();
            this.tenantAwareDecisionId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionId, DbTenantAwareKey.PlacementType.PREFIX);
            this.latestDecisionKeysByDecisionId = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_BY_ID, transactionContext, this.tenantAwareDecisionId, this.fkDecision);
            this.dbDecisionRequirementsKey = new DbLong();
            this.tenantAwareDecisionRequirementsKey = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionRequirementsKey, DbTenantAwareKey.PlacementType.PREFIX);
            this.fkDecisionRequirements = new DbForeignKey(this.tenantAwareDecisionRequirementsKey, (Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS);
            this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
            this.decisionRequirementsByKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS, transactionContext, this.tenantAwareDecisionRequirementsKey, (DbValue)this.dbPersistedDecisionRequirements);
            this.dbDecisionRequirementsId = new DbString();
            this.tenantAwareDecisionRequirementsId = new DbTenantAwareKey(this.tenantIdKey, (DbKey)this.dbDecisionRequirementsId, DbTenantAwareKey.PlacementType.PREFIX);
            this.latestDecisionRequirementsKeysById = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_LATEST_DECISION_REQUIREMENTS_BY_ID, transactionContext, this.tenantAwareDecisionRequirementsId, this.fkDecisionRequirements);
            this.dbDecisionRequirementsKeyAndDecisionKey = new DbCompositeKey(this.fkDecisionRequirements, this.fkDecision);
            this.decisionKeyByDecisionRequirementsKey = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_REQUIREMENTS_KEY, transactionContext, this.dbDecisionRequirementsKeyAndDecisionKey, (DbValue)DbNil.INSTANCE);
            this.dbDecisionVersion = new DbInt();
            this.decisionIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionId, (DbKey)this.dbDecisionVersion);
            this.tenantAwareDecisionIdAndVersion = new DbTenantAwareKey(this.tenantIdKey, this.decisionIdAndVersion, DbTenantAwareKey.PlacementType.PREFIX);
            this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.tenantAwareDecisionIdAndVersion, this.fkDecision);
            this.dbDecisionRequirementsVersion = new DbInt();
            this.decisionRequirementsIdAndVersion = new DbCompositeKey((DbKey)this.dbDecisionRequirementsId, (DbKey)this.dbDecisionRequirementsVersion);
            this.tenantAwareDecisionRequirementsIdAndVersion = new DbTenantAwareKey(this.tenantIdKey, this.decisionRequirementsIdAndVersion, DbTenantAwareKey.PlacementType.PREFIX);
            this.decisionRequirementsKeyByIdAndVersion = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.tenantAwareDecisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        }
    }
}

