/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.event;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableBoundaryEvent;
import io.camunda.zeebe.util.Either;

public final class BoundaryEventProcessor
implements BpmnElementProcessor<ExecutableBoundaryEvent> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;

    public BoundaryEventProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
    }

    @Override
    public Class<ExecutableBoundaryEvent> getType() {
        return ExecutableBoundaryEvent.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableBoundaryEvent element, BpmnElementContext context) {
        throw new BpmnProcessingException(context, "Expected an ACTIVATING and ACTIVATED event for the boundary event but found an ACTIVATE command.");
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableBoundaryEvent element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> this.stateTransitionBehavior.transitionToCompleted(element, context)).thenDo(completed -> this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed));
    }

    @Override
    public void onTerminate(ExecutableBoundaryEvent element, BpmnElementContext context) {
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

