/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.task;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnCompensationSubscriptionBehaviour;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.bpmn.task.JobWorkerTaskSupportingProcessor;
import io.camunda.zeebe.engine.processing.common.EventTriggerBehavior;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableScriptTask;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

public final class ScriptTaskProcessor
extends JobWorkerTaskSupportingProcessor<ExecutableScriptTask> {
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnStateBehavior stateBehavior;
    private final ExpressionProcessor expressionProcessor;
    private final EventTriggerBehavior eventTriggerBehavior;
    private final BpmnCompensationSubscriptionBehaviour compensationSubscriptionBehaviour;

    public ScriptTaskProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        super(bpmnBehaviors, stateTransitionBehavior);
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.expressionProcessor = bpmnBehaviors.expressionBehavior();
        this.eventTriggerBehavior = bpmnBehaviors.eventTriggerBehavior();
        this.compensationSubscriptionBehaviour = bpmnBehaviors.compensationSubscriptionBehaviour();
    }

    @Override
    public Class<ExecutableScriptTask> getType() {
        return ExecutableScriptTask.class;
    }

    @Override
    protected boolean isJobBehavior(ExecutableScriptTask element, BpmnElementContext context) {
        if (element.getExpression() != null) {
            return false;
        }
        if (element.getJobWorkerProperties() == null) {
            throw new BpmnProcessingException(context, "Expected to process script task, but could not determine processing behavior");
        }
        return true;
    }

    @Override
    protected Either<Failure, ?> onActivateInternal(ExecutableScriptTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyInputMappings(context, element).flatMap(ok -> this.evaluateScript(element, context)).thenDo(ok -> {
            BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
            this.stateTransitionBehavior.completeElement(activated);
        });
    }

    @Override
    protected Either<Failure, ?> onCompleteInternal(ExecutableScriptTask element, BpmnElementContext context) {
        return this.variableMappingBehavior.applyOutputMappings(context, element).flatMap(ok -> {
            this.compensationSubscriptionBehaviour.createCompensationSubscription(element, context);
            return this.stateTransitionBehavior.transitionToCompleted(element, context);
        }).thenDo(completed -> {
            this.compensationSubscriptionBehaviour.completeCompensationHandler((BpmnElementContext)completed);
            this.stateTransitionBehavior.takeOutgoingSequenceFlows(element, (BpmnElementContext)completed);
        });
    }

    @Override
    protected void onTerminateInternal(ExecutableScriptTask element, BpmnElementContext context) {
        ElementInstance flowScopeInstance = this.stateBehavior.getFlowScopeInstance(context);
        this.incidentBehavior.resolveIncidents(context);
        this.eventSubscriptionBehavior.findEventTrigger(context).filter(eventTrigger -> flowScopeInstance.isActive()).ifPresentOrElse(eventTrigger -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), terminated.getFlowScopeKey(), (EventTrigger)((Object)eventTrigger), terminated);
        }, () -> {
            BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
            this.stateTransitionBehavior.onElementTerminated(element, terminated);
        });
    }

    private void triggerProcessEventWithResultVariable(BpmnElementContext context, String resultVariableName, DirectBuffer result) {
        DirectBuffer resultVariable = ScriptTaskProcessor.serializeToNamedVariable(resultVariableName, result);
        this.eventTriggerBehavior.triggeringProcessEvent(context.getProcessDefinitionKey(), context.getProcessInstanceKey(), context.getTenantId(), context.getElementInstanceKey(), context.getElementId(), resultVariable);
    }

    private static DirectBuffer serializeToNamedVariable(String name, DirectBuffer value) {
        ExpandableArrayBuffer resultBuffer = new ExpandableArrayBuffer();
        MsgPackWriter writer = new MsgPackWriter();
        writer.wrap((MutableDirectBuffer)resultBuffer, 0);
        writer.writeMapHeader(1);
        writer.writeString(BufferUtil.wrapString((String)name));
        writer.writeRaw(value);
        return resultBuffer;
    }

    private Either<Failure, DirectBuffer> evaluateScript(ExecutableScriptTask element, BpmnElementContext context) {
        Either<Failure, DirectBuffer> resultOrFailure = this.expressionProcessor.evaluateAnyExpression(element.getExpression(), context.getElementInstanceKey());
        resultOrFailure.ifRight(result -> this.triggerProcessEventWithResultVariable(context, element.getResultVariable(), (DirectBuffer)result));
        return resultOrFailure;
    }
}

