/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.transformer;

import io.camunda.zeebe.el.EvaluationResult;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.el.ResultType;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableMessage;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableProcess;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableSignal;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableStartEvent;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.ModelElementTransformer;
import io.camunda.zeebe.engine.processing.deployment.model.transformation.TransformContext;
import io.camunda.zeebe.model.bpmn.instance.FlowNode;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;

public final class StartEventTransformer
implements ModelElementTransformer<StartEvent> {
    @Override
    public Class<StartEvent> getType() {
        return StartEvent.class;
    }

    @Override
    public void transform(StartEvent element, TransformContext context) {
        ExecutableProcess process = context.getCurrentProcess();
        ExecutableStartEvent startEvent = process.getElementById(element.getId(), ExecutableStartEvent.class);
        startEvent.setInterrupting(element.isInterrupting());
        startEvent.setEventType(BpmnEventType.NONE);
        if (startEvent.isMessage()) {
            startEvent.setEventType(BpmnEventType.MESSAGE);
        } else if (startEvent.isTimer()) {
            startEvent.setEventType(BpmnEventType.TIMER);
        } else if (startEvent.isError()) {
            startEvent.setEventType(BpmnEventType.ERROR);
        } else if (startEvent.isEscalation()) {
            startEvent.setEventType(BpmnEventType.ESCALATION);
        } else if (startEvent.isSignal()) {
            startEvent.setEventType(BpmnEventType.SIGNAL);
        } else if (startEvent.isCompensation()) {
            startEvent.setEventType(BpmnEventType.COMPENSATION);
        }
        if (element.getScope() instanceof FlowNode) {
            FlowNode scope = (FlowNode)element.getScope();
            ExecutableFlowElementContainer subprocess = process.getElementById(scope.getId(), ExecutableFlowElementContainer.class);
            subprocess.addStartEvent(startEvent);
        } else {
            process.addStartEvent(startEvent);
        }
        if (startEvent.isMessage() && element.getScope() instanceof Process) {
            this.evaluateMessageNameExpression(startEvent, context);
        }
        if (startEvent.isSignal() && element.getScope() instanceof Process) {
            this.evaluateSignalNameExpression(startEvent, context);
        }
    }

    private void evaluateMessageNameExpression(ExecutableStartEvent startEvent, TransformContext context) {
        ExecutableMessage message = startEvent.getMessage();
        if (message.getMessageName().isEmpty()) {
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            EvaluationResult messageNameResult = expressionLanguage.evaluateExpression(message.getMessageNameExpression(), variable -> null);
            if (messageNameResult.isFailure()) {
                throw new IllegalStateException(String.format("Error while evaluating '%s': %s", message.getMessageNameExpression(), messageNameResult.getFailureMessage()));
            }
            if (messageNameResult.getType() == ResultType.STRING) {
                String messageName = messageNameResult.getString();
                message.setMessageName(messageName);
            } else {
                throw new IllegalStateException(String.format("Expected FEEL expression or static value of '%s' of type STRING, but was: %s", messageNameResult.getExpression(), messageNameResult.getType().name()));
            }
        }
    }

    private void evaluateSignalNameExpression(ExecutableStartEvent startEvent, TransformContext context) {
        ExecutableSignal signal = startEvent.getSignal();
        if (signal.getSignalName().isEmpty()) {
            ExpressionLanguage expressionLanguage = context.getExpressionLanguage();
            EvaluationResult signalNameResult = expressionLanguage.evaluateExpression(signal.getSignalNameExpression(), variable -> null);
            if (signalNameResult.isFailure()) {
                throw new IllegalStateException(String.format("Error while evaluating '%s': %s", signal.getSignalNameExpression(), signalNameResult.getFailureMessage()));
            }
            if (signalNameResult.getType() == ResultType.STRING) {
                String signalName = signalNameResult.getString();
                signal.setSignalName(signalName);
            } else {
                throw new IllegalStateException(String.format("Expected FEEL expression or static value of '%s' of type STRING, but was: %s", signalNameResult.getExpression(), signalNameResult.getType().name()));
            }
        }
    }
}

