/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.processing.job.JobTimeoutChecker;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobTimeoutCheckerScheduler
implements StreamProcessorLifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(JobTimeoutCheckerScheduler.class);
    private final Duration pollingInterval;
    private final JobTimeoutChecker jobTimeoutChecker;

    public JobTimeoutCheckerScheduler(JobState state, Duration pollingInterval, int batchLimit) {
        this.pollingInterval = pollingInterval;
        this.jobTimeoutChecker = new JobTimeoutChecker(state, pollingInterval, batchLimit);
    }

    public void onRecovered(ReadonlyStreamProcessorContext processingContext) {
        this.jobTimeoutChecker.setProcessingContext(processingContext);
        this.jobTimeoutChecker.setShouldReschedule(true);
        this.jobTimeoutChecker.schedule(this.pollingInterval);
    }

    public void onClose() {
        this.cancelTimer();
    }

    public void onFailed() {
        this.cancelTimer();
    }

    public void onPaused() {
        this.cancelTimer();
    }

    public void onResumed() {
        this.jobTimeoutChecker.setShouldReschedule(true);
        this.jobTimeoutChecker.schedule(this.pollingInterval);
    }

    private void cancelTimer() {
        this.jobTimeoutChecker.setShouldReschedule(false);
        LOG.trace("Job timeout checker canceled!");
    }
}

