/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.metrics;

import io.camunda.zeebe.protocol.record.value.JobKind;
import io.prometheus.client.Counter;

public final class JobMetrics {
    private static final Counter JOB_EVENTS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("job_events_total")).help("Number of job events")).labelNames(new String[]{"action", "partition", "type", "job_kind"})).register();
    private final String partitionIdLabel;

    public JobMetrics(int partitionId) {
        this.partitionIdLabel = String.valueOf(partitionId);
    }

    private void jobEvent(String action, String type, JobKind jobKind) {
        ((Counter.Child)JOB_EVENTS.labels(new String[]{action, this.partitionIdLabel, type, jobKind.name()})).inc();
    }

    public void jobCreated(String type, JobKind jobKind) {
        this.jobEvent("created", type, jobKind);
    }

    public void jobActivated(String type, JobKind jobKind, int activatedJobs) {
        ((Counter.Child)JOB_EVENTS.labels(new String[]{"activated", this.partitionIdLabel, type, jobKind.name()})).inc((double)activatedJobs);
    }

    public void jobTimedOut(String type, JobKind jobKind) {
        this.jobEvent("timed out", type, jobKind);
    }

    public void jobCompleted(String type, JobKind jobKind) {
        this.jobEvent("completed", type, jobKind);
    }

    public void jobFailed(String type, JobKind jobKind) {
        this.jobEvent("failed", type, jobKind);
    }

    public void jobCanceled(String type, JobKind jobKind) {
        this.jobEvent("canceled", type, jobKind);
    }

    public void jobErrorThrown(String type, JobKind jobKind) {
        this.jobEvent("error thrown", type, jobKind);
    }

    public void jobNotification(String type, JobKind jobKind) {
        this.jobEvent("workers notified", type, jobKind);
    }

    public void jobPush(String type, JobKind jobKind) {
        this.jobEvent("pushed", type, jobKind);
    }

    static void clear() {
        JOB_EVENTS.clear();
    }
}

