/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.container;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContainerProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnVariableMappingBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableFlowElementContainer;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.util.Either;

public final class EventSubProcessProcessor
implements BpmnElementContainerProcessor<ExecutableFlowElementContainer> {
    private final BpmnStateBehavior stateBehavior;
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnVariableMappingBehavior variableMappingBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnJobBehavior jobBehavior;

    public EventSubProcessProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateBehavior = bpmnBehaviors.stateBehavior();
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.variableMappingBehavior = bpmnBehaviors.variableMappingBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableFlowElementContainer> getType() {
        return ExecutableFlowElementContainer.class;
    }

    @Override
    public Either<Failure, ?> onActivate(ExecutableFlowElementContainer element, BpmnElementContext activating) {
        return this.variableMappingBehavior.applyInputMappings(activating, element);
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableFlowElementContainer element, BpmnElementContext context) {
        BpmnElementContext activated = this.stateTransitionBehavior.transitionToActivated(context, element.getEventType());
        this.stateTransitionBehavior.activateChildInstance(activated, element.getStartEvents().getFirst());
        return SUCCESS;
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableFlowElementContainer element, BpmnElementContext completing) {
        return this.variableMappingBehavior.applyOutputMappings(completing, element);
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableFlowElementContainer element, BpmnElementContext context) {
        return this.stateTransitionBehavior.transitionToCompleted(element, context);
    }

    @Override
    public void onTerminate(ExecutableFlowElementContainer element, BpmnElementContext terminating) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(terminating);
        }
        this.incidentBehavior.resolveIncidents(terminating);
        boolean noActiveChildInstances = this.stateTransitionBehavior.terminateChildInstances(terminating);
        if (noActiveChildInstances) {
            this.onChildTerminated(element, terminating, (BpmnElementContext)null);
        }
    }

    @Override
    public void afterExecutionPathCompleted(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext, Boolean satisfiesCompletionCondition) {
        if (this.stateBehavior.canBeCompleted(childContext)) {
            this.stateTransitionBehavior.completeElement(flowScopeContext);
        }
    }

    @Override
    public void onChildTerminated(ExecutableFlowElementContainer element, BpmnElementContext flowScopeContext, BpmnElementContext childContext) {
        ElementInstance flowScopeInstance = this.stateBehavior.getElementInstance(flowScopeContext);
        if (childContext == null || this.stateBehavior.canBeTerminated(childContext)) {
            if (flowScopeInstance.isTerminating()) {
                BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(flowScopeContext, element.getEventType());
                this.stateTransitionBehavior.onElementTerminated(element, terminated);
            } else if (this.stateBehavior.isInterruptedByTerminateEndEvent(flowScopeContext, flowScopeInstance)) {
                this.stateTransitionBehavior.completeElement(flowScopeContext);
            }
        }
    }
}

