/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.deployment.model.validation;

import io.camunda.zeebe.el.Expression;
import io.camunda.zeebe.el.ExpressionLanguage;
import io.camunda.zeebe.engine.processing.common.ExpressionProcessor;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.timer.CronTimer;
import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.camunda.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.camunda.zeebe.util.Either;
import java.time.format.DateTimeParseException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class TimerCatchEventExpressionValidator
implements ModelElementValidator<CatchEvent> {
    private static final long NO_VARIABLE_SCOPE = -1L;
    private final ExpressionLanguage expressionLanguage;
    private final ExpressionProcessor expressionProcessor;

    public TimerCatchEventExpressionValidator(ExpressionLanguage expressionLanguage, ExpressionProcessor expressionProcessor) {
        this.expressionLanguage = expressionLanguage;
        this.expressionProcessor = expressionProcessor;
    }

    public Class<CatchEvent> getElementType() {
        return CatchEvent.class;
    }

    public void validate(CatchEvent element, ValidationResultCollector validationResultCollector) {
        boolean isTimerStartEventOfProcess = element instanceof StartEvent && element.getScope() instanceof Process;
        Predicate<Expression> expressionFilter = expression -> isTimerStartEventOfProcess || expression.isStatic();
        element.getEventDefinitions().stream().filter(TimerEventDefinition.class::isInstance).map(TimerEventDefinition.class::cast).forEach(definition -> this.validation((TimerEventDefinition)definition, expressionFilter, validationResultCollector));
    }

    private void validation(TimerEventDefinition timerEventDefinition, Predicate<Expression> expressionFilter, ValidationResultCollector validationResultCollector) {
        this.evaluateTimerExpression(timerEventDefinition, expressionFilter).ifLeft(failure -> validationResultCollector.addError(0, failure.getMessage()));
    }

    private Either<Failure, ?> evaluateTimerExpression(TimerEventDefinition timerEventDefinition, Predicate<Expression> expressionFilter) {
        String timeDate;
        Expression expression;
        if (timerEventDefinition.getTimeDuration() != null) {
            String duration = timerEventDefinition.getTimeDuration().getTextContent();
            Expression expression2 = this.expressionLanguage.parseExpression(duration);
            if (expressionFilter.test(expression2)) {
                return this.expressionProcessor.evaluateIntervalExpression(expression2, -1L).mapLeft(this.wrapFailure("duration"));
            }
        } else if (timerEventDefinition.getTimeCycle() != null) {
            String cycle = timerEventDefinition.getTimeCycle().getTextContent();
            Expression expression3 = this.expressionLanguage.parseExpression(cycle);
            if (expressionFilter.test(expression3)) {
                try {
                    return this.expressionProcessor.evaluateStringExpression(expression3, -1L).map(text -> {
                        if (text.startsWith("R")) {
                            return RepeatingInterval.parse((String)text);
                        }
                        return CronTimer.parse(text);
                    }).mapLeft(this.wrapFailure("cycle"));
                }
                catch (DateTimeParseException e) {
                    Failure failureDetails = new Failure(e.getMessage());
                    return Either.left((Object)failureDetails).mapLeft(this.wrapFailure("cycle"));
                }
            }
        } else if (timerEventDefinition.getTimeDate() != null && expressionFilter.test(expression = this.expressionLanguage.parseExpression(timeDate = timerEventDefinition.getTimeDate().getTextContent()))) {
            return this.expressionProcessor.evaluateDateTimeExpression(expression, -1L).mapLeft(this.wrapFailure("date"));
        }
        return Either.right(null);
    }

    private Function<Failure, Failure> wrapFailure(String timerType) {
        return failureDetails -> new Failure(String.format("Invalid timer %s expression (%s)", timerType, failureDetails.getMessage()));
    }
}

