/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.processinstance;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContextImpl;
import io.camunda.zeebe.engine.processing.common.CatchEventBehavior;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEvent;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableCatchEventSupplier;
import io.camunda.zeebe.engine.processing.distribution.CommandDistributionBehavior;
import io.camunda.zeebe.engine.processing.processinstance.ProcessInstanceMigrationPreconditions;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.StateWriter;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.TypedCommandWriter;
import io.camunda.zeebe.engine.state.deployment.DeployedProcess;
import io.camunda.zeebe.engine.state.immutable.DistributionState;
import io.camunda.zeebe.engine.state.immutable.ProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.instance.TimerInstance;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.routing.RoutingInfo;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import io.camunda.zeebe.protocol.impl.record.value.timer.TimerRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.MessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessMessageSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.SignalSubscriptionIntent;
import io.camunda.zeebe.protocol.record.intent.TimerIntent;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.agrona.DirectBuffer;

public class ProcessInstanceMigrationCatchEventBehaviour {
    private final ProcessMessageSubscriptionState processMessageSubscriptionState;
    private final CatchEventBehavior catchEventBehavior;
    private final TypedCommandWriter commandWriter;
    private final CommandDistributionBehavior commandDistributionBehavior;
    private final DistributionState distributionState;
    private final StateWriter stateWriter;
    private final int currentPartitionId;
    private final RoutingInfo routingInfo;

    public ProcessInstanceMigrationCatchEventBehaviour(ProcessMessageSubscriptionState processMessageSubscriptionState, CatchEventBehavior catchEventBehavior, TypedCommandWriter commandWriter, CommandDistributionBehavior commandDistributionBehavior, DistributionState distributionState, StateWriter stateWriter, int currentPartitionId, RoutingInfo routingInfo) {
        this.processMessageSubscriptionState = processMessageSubscriptionState;
        this.catchEventBehavior = catchEventBehavior;
        this.commandWriter = commandWriter;
        this.commandDistributionBehavior = commandDistributionBehavior;
        this.distributionState = distributionState;
        this.stateWriter = stateWriter;
        this.currentPartitionId = currentPartitionId;
        this.routingInfo = routingInfo;
    }

    public void handleCatchEvents(ElementInstance elementInstance, DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId, ProcessInstanceRecord elementInstanceRecord, String targetElementId, long processInstanceKey, String elementId) {
        BpmnElementContextImpl context = new BpmnElementContextImpl();
        context.init(elementInstance.getKey(), elementInstanceRecord, elementInstance.getState());
        ExecutableCatchEventSupplier targetElement = targetProcessDefinition.getProcess().getElementById(targetElementId, ExecutableCatchEventSupplier.class);
        List<ProcessMessageSubscription> processMessageSubscriptionsToMigrate = this.unsubscribeFromMessageEvents(elementInstance, sourceElementIdToTargetElementId, processInstanceKey, elementId);
        List<TimerInstance> timerInstancesToMigrate = this.unsubscribeFromTimerEvents(elementInstance, sourceElementIdToTargetElementId);
        List<SignalSubscription> signalSubscriptionsToMigrate = this.unsubscribeFromSignalEvents(elementInstance, sourceElementIdToTargetElementId);
        Map<String, Boolean> targetCatchEventIdToInterrupting = this.subscribeToAllCatchEvents(elementInstance, sourceElementIdToTargetElementId, elementInstanceRecord, targetElementId, processInstanceKey, elementId, context, targetElement);
        this.migrateMessageEvents(targetProcessDefinition, sourceElementIdToTargetElementId, processMessageSubscriptionsToMigrate, targetCatchEventIdToInterrupting);
        this.migrateTimerEvents(targetProcessDefinition, sourceElementIdToTargetElementId, timerInstancesToMigrate);
        this.migrateSignalEvents(targetProcessDefinition, sourceElementIdToTargetElementId, signalSubscriptionsToMigrate);
    }

    private void migrateSignalEvents(DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId, List<SignalSubscription> signalSubscriptionsToMigrate) {
        signalSubscriptionsToMigrate.forEach(signalSubscription -> {
            String sourceCatchEventId = signalSubscription.getRecord().getCatchEventId();
            String targetCatchEventId = (String)sourceElementIdToTargetElementId.get(sourceCatchEventId);
            SignalSubscriptionRecord signalSubscriptionRecord = signalSubscription.getRecord();
            SignalSubscriptionRecord signalSubscriptionRecordCopy = new SignalSubscriptionRecord();
            signalSubscriptionRecordCopy.wrap(signalSubscriptionRecord);
            signalSubscriptionRecordCopy.setProcessDefinitionKey(targetProcessDefinition.getKey());
            signalSubscriptionRecordCopy.setCatchEventId(BufferUtil.wrapString((String)targetCatchEventId));
            signalSubscriptionRecordCopy.setBpmnProcessId(targetProcessDefinition.getBpmnProcessId());
            this.stateWriter.appendFollowUpEvent(signalSubscription.getKey(), (Intent)SignalSubscriptionIntent.MIGRATED, (RecordValue)signalSubscriptionRecordCopy);
        });
    }

    private void migrateTimerEvents(DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId, List<TimerInstance> timerInstancesToMigrate) {
        timerInstancesToMigrate.forEach(timerInstance -> {
            String sourceCatchEventId = BufferUtil.bufferAsString((DirectBuffer)timerInstance.getHandlerNodeId());
            String targetCatchEventId = (String)sourceElementIdToTargetElementId.get(sourceCatchEventId);
            TimerRecord timerRecord = new TimerRecord();
            timerRecord.setElementInstanceKey(timerInstance.getElementInstanceKey());
            timerRecord.setProcessInstanceKey(timerInstance.getProcessInstanceKey());
            timerRecord.setDueDate(timerInstance.getDueDate());
            timerRecord.setTargetElementId(BufferUtil.wrapString((String)targetCatchEventId));
            timerRecord.setRepetitions(timerInstance.getRepetitions());
            timerRecord.setProcessDefinitionKey(targetProcessDefinition.getKey());
            timerRecord.setTenantId(timerInstance.getTenantId());
            this.stateWriter.appendFollowUpEvent(timerInstance.getKey(), (Intent)TimerIntent.MIGRATED, (RecordValue)timerRecord);
        });
    }

    private void migrateMessageEvents(DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId, List<ProcessMessageSubscription> processMessageSubscriptionsToMigrate, Map<String, Boolean> targetCatchEventIdToInterrupting) {
        processMessageSubscriptionsToMigrate.forEach(processMessageSubscription -> this.migrateMessageSubscription(targetProcessDefinition, sourceElementIdToTargetElementId, (ProcessMessageSubscription)((Object)processMessageSubscription), targetCatchEventIdToInterrupting));
    }

    private Map<String, Boolean> subscribeToAllCatchEvents(ElementInstance elementInstance, Map<String, String> sourceElementIdToTargetElementId, ProcessInstanceRecord elementInstanceRecord, String targetElementId, long processInstanceKey, String elementId, BpmnElementContextImpl context, ExecutableCatchEventSupplier targetElement) {
        HashMap<String, Boolean> targetCatchEventIdToInterrupting = new HashMap<String, Boolean>();
        this.catchEventBehavior.subscribeToEvents(context, targetElement, executableCatchEvent -> {
            String targetCatchEventId = BufferUtil.bufferAsString((DirectBuffer)executableCatchEvent.getId());
            if (sourceElementIdToTargetElementId.containsValue(targetCatchEventId)) {
                targetCatchEventIdToInterrupting.put(targetCatchEventId, executableCatchEvent.isInterrupting());
                return false;
            }
            return !elementInstance.isInterrupted();
        }, catchEvent -> {
            ExecutableCatchEvent element = catchEvent.element();
            String targetCatchEventId = BufferUtil.bufferAsString((DirectBuffer)element.getId());
            if (element.isMessage()) {
                this.requireNoSubscriptionForMessage(elementInstance, catchEvent.messageName(), elementInstanceRecord.getTenantId(), targetCatchEventId);
            }
            return true;
        }).ifLeft(failure -> {
            throw new ProcessInstanceMigrationPreconditions.ProcessInstanceMigrationPreconditionFailedException("Expected to migrate process instance '%s' but active element with id '%s' is mapped to element with id '%s' that must be subscribed to a catch event. %s".formatted(processInstanceKey, elementId, targetElementId, failure.getMessage()), RejectionType.INVALID_STATE);
        });
        return targetCatchEventIdToInterrupting;
    }

    private List<SignalSubscription> unsubscribeFromSignalEvents(ElementInstance elementInstance, Map<String, String> sourceElementIdToTargetElementId) {
        ArrayList<SignalSubscription> signalSubscriptionsToMigrate = new ArrayList<SignalSubscription>();
        this.catchEventBehavior.unsubscribeFromSignalEventsBySubscriptionFilter(elementInstance.getKey(), signalSubscription -> {
            if (sourceElementIdToTargetElementId.containsKey(signalSubscription.getRecord().getCatchEventId())) {
                SignalSubscription copy = new SignalSubscription();
                copy.copyFrom((BufferWriter)signalSubscription);
                signalSubscriptionsToMigrate.add(copy);
                return false;
            }
            return true;
        });
        return signalSubscriptionsToMigrate;
    }

    private List<TimerInstance> unsubscribeFromTimerEvents(ElementInstance elementInstance, Map<String, String> sourceElementIdToTargetElementId) {
        ArrayList<TimerInstance> timerInstancesToMigrate = new ArrayList<TimerInstance>();
        this.catchEventBehavior.unsubscribeFromTimerEventsByInstanceFilter(elementInstance.getKey(), timerInstance -> {
            if (sourceElementIdToTargetElementId.containsKey(BufferUtil.bufferAsString((DirectBuffer)timerInstance.getHandlerNodeId()))) {
                TimerInstance copy = new TimerInstance();
                copy.copyFrom((BufferWriter)timerInstance);
                timerInstancesToMigrate.add(copy);
                return false;
            }
            return true;
        });
        return timerInstancesToMigrate;
    }

    private List<ProcessMessageSubscription> unsubscribeFromMessageEvents(ElementInstance elementInstance, Map<String, String> sourceElementIdToTargetElementId, long processInstanceKey, String elementId) {
        ArrayList<ProcessMessageSubscription> processMessageSubscriptionsToMigrate = new ArrayList<ProcessMessageSubscription>();
        this.catchEventBehavior.unsubscribeFromMessageEvents(elementInstance.getKey(), subscription -> {
            long distributionKey = subscription.getKey();
            ProcessInstanceMigrationPreconditions.requireNoPendingMsgSubMigrationDistribution(this.distributionState, distributionKey, elementId, processInstanceKey, subscription.getRecord().getElementId());
            String catchEventId = subscription.getRecord().getElementId();
            if (sourceElementIdToTargetElementId.containsKey(catchEventId)) {
                ProcessMessageSubscription copySubscription = new ProcessMessageSubscription();
                copySubscription.copyFrom((BufferWriter)subscription);
                processMessageSubscriptionsToMigrate.add(copySubscription);
                return false;
            }
            return true;
        });
        return processMessageSubscriptionsToMigrate;
    }

    private void migrateMessageSubscription(DeployedProcess targetProcessDefinition, Map<String, String> sourceElementIdToTargetElementId, ProcessMessageSubscription processMessageSubscription, Map<String, Boolean> targetCatchEventIdToInterrupting) {
        ProcessMessageSubscriptionRecord processMessageSubscriptionRecord = processMessageSubscription.getRecord();
        String sourceCatchEventId = processMessageSubscriptionRecord.getElementId();
        String targetCatchEventId = sourceElementIdToTargetElementId.get(sourceCatchEventId);
        Boolean interrupting = targetCatchEventIdToInterrupting.get(targetCatchEventId);
        MessageSubscriptionRecord messageSubscription = new MessageSubscriptionRecord().setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementInstanceKey(processMessageSubscriptionRecord.getElementInstanceKey()).setProcessInstanceKey(processMessageSubscriptionRecord.getProcessInstanceKey()).setMessageName(processMessageSubscriptionRecord.getMessageNameBuffer()).setCorrelationKey(processMessageSubscriptionRecord.getCorrelationKeyBuffer()).setTenantId(processMessageSubscriptionRecord.getTenantId());
        if (interrupting != null) {
            processMessageSubscriptionRecord.setInterrupting(interrupting.booleanValue());
            messageSubscription.setInterrupting(interrupting.booleanValue());
        }
        this.stateWriter.appendFollowUpEvent(processMessageSubscription.getKey(), (Intent)ProcessMessageSubscriptionIntent.MIGRATED, (RecordValue)processMessageSubscriptionRecord.setBpmnProcessId(targetProcessDefinition.getBpmnProcessId()).setElementId(BufferUtil.wrapString((String)targetCatchEventId)));
        int subscriptionPartitionId = this.routingInfo.partitionForCorrelationKey(BufferUtil.wrapString((String)messageSubscription.getCorrelationKey()));
        long distributionKey = processMessageSubscription.getKey();
        if (this.currentPartitionId == subscriptionPartitionId) {
            this.commandWriter.appendFollowUpCommand(distributionKey, (Intent)MessageSubscriptionIntent.MIGRATE, (RecordValue)messageSubscription);
        } else {
            this.commandDistributionBehavior.withKey(distributionKey).unordered().forPartition(processMessageSubscriptionRecord.getSubscriptionPartitionId()).distribute(ValueType.MESSAGE_SUBSCRIPTION, (Intent)MessageSubscriptionIntent.MIGRATE, messageSubscription);
        }
    }

    private void requireNoSubscriptionForMessage(ElementInstance elementInstance, DirectBuffer messageName, String tenantId, String targetCatchEventId) {
        boolean existSubscriptionForMessageName = this.processMessageSubscriptionState.existSubscriptionForElementInstance(elementInstance.getKey(), messageName, tenantId);
        ProcessInstanceMigrationPreconditions.requireNoSubscriptionForMessage(existSubscriptionForMessageName, elementInstance, messageName, targetCatchEventId);
    }
}

