/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.clock;

import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.stream.api.StreamClock;
import java.time.Duration;
import java.time.Instant;

final class DbClockModification
extends UnpackedObject
implements DbValue {
    private final LongProperty timeProperty = new LongProperty("time", 0L);
    private final EnumProperty<ModificationType> typeProperty = new EnumProperty("type", ModificationType.class, (Enum)ModificationType.NONE);

    DbClockModification() {
        super(2);
        this.declareProperty((BaseProperty)this.typeProperty).declareProperty((BaseProperty)this.timeProperty);
    }

    DbClockModification pinAt(long pinnedEpoch) {
        this.reset();
        this.typeProperty.setValue((Enum)ModificationType.PIN);
        this.timeProperty.setValue(pinnedEpoch);
        return this;
    }

    DbClockModification offsetBy(long offsetMillis) {
        this.reset();
        this.typeProperty.setValue((Enum)ModificationType.OFFSET);
        this.timeProperty.setValue(offsetMillis);
        return this;
    }

    StreamClock.ControllableStreamClock.Modification modification() {
        return switch (((ModificationType)this.typeProperty.getValue()).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> StreamClock.ControllableStreamClock.Modification.none();
            case 1 -> StreamClock.ControllableStreamClock.Modification.pinAt((Instant)Instant.ofEpochMilli(this.timeProperty.getValue()));
            case 2 -> StreamClock.ControllableStreamClock.Modification.offsetBy((Duration)Duration.ofMillis(this.timeProperty.getValue()));
        };
    }

    static enum ModificationType {
        NONE,
        PIN,
        OFFSET;

    }
}

