/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.routing;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.RoutingState;
import io.camunda.zeebe.engine.state.mutable.MutableRoutingState;
import io.camunda.zeebe.engine.state.routing.PersistedRoutingInfo;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class DbRoutingState
implements MutableRoutingState {
    private static final String CURRENT_KEY = "CURRENT";
    private final ColumnFamily<DbString, PersistedRoutingInfo> columnFamily;
    private final DbString key = new DbString();
    private final PersistedRoutingInfo currentRoutingInfo = new PersistedRoutingInfo();

    public DbRoutingState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.columnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ROUTING, transactionContext, (DbKey)this.key, (DbValue)this.currentRoutingInfo);
    }

    @Override
    public Set<Integer> partitions() {
        this.key.wrapString(CURRENT_KEY);
        return ((PersistedRoutingInfo)this.columnFamily.get((DbKey)this.key)).getPartitions();
    }

    @Override
    public RoutingState.MessageCorrelation messageCorrelation() {
        this.key.wrapString(CURRENT_KEY);
        return ((PersistedRoutingInfo)this.columnFamily.get((DbKey)this.key)).getMessageCorrelation();
    }

    @Override
    public boolean isInitialized() {
        this.key.wrapString(CURRENT_KEY);
        return this.columnFamily.exists((DbKey)this.key);
    }

    @Override
    public void initializeRoutingInfo(int partitionCount) {
        Set<Integer> partitions = IntStream.rangeClosed(1, partitionCount).boxed().collect(Collectors.toUnmodifiableSet());
        this.key.wrapString(CURRENT_KEY);
        this.currentRoutingInfo.reset();
        this.currentRoutingInfo.setPartitions(partitions);
        this.currentRoutingInfo.setMessageCorrelation(new RoutingState.MessageCorrelation.HashMod(partitionCount));
        this.columnFamily.insert((DbKey)this.key, (DbValue)this.currentRoutingInfo);
    }
}

