/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.user;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.immutable.UserState;
import io.camunda.zeebe.engine.state.mutable.MutableUserState;
import io.camunda.zeebe.engine.state.user.PersistedUser;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.user.UserRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class DbUserState
implements UserState,
MutableUserState {
    private final PersistedUser persistedUser = new PersistedUser();
    private final DbString username = new DbString();
    private final DbLong userKey = new DbLong();
    private final DbForeignKey<DbLong> fkUserKey = new DbForeignKey((DbKey)this.userKey, (Enum)ZbColumnFamilies.USERS);
    private final ColumnFamily<DbString, DbForeignKey<DbLong>> userKeyByUsernameColumnFamily;
    private final ColumnFamily<DbKey, PersistedUser> userByUserKeyColumnFamily;

    public DbUserState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.userKeyByUsernameColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.USER_KEY_BY_USERNAME, transactionContext, (DbKey)this.username, this.fkUserKey);
        this.userByUserKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.USERS, transactionContext, (DbKey)this.userKey, (DbValue)this.persistedUser);
    }

    @Override
    public void create(long key, UserRecord user) {
        this.username.wrapBuffer(user.getUsernameBuffer());
        this.userKey.wrapLong(key);
        this.persistedUser.setUser(user);
        this.userByUserKeyColumnFamily.insert((DbKey)this.userKey, (DbValue)this.persistedUser);
        this.userKeyByUsernameColumnFamily.insert((DbKey)this.username, this.fkUserKey);
    }

    @Override
    public UserRecord getUser(DirectBuffer username) {
        this.username.wrapBuffer(username);
        DbForeignKey key = (DbForeignKey)this.userKeyByUsernameColumnFamily.get((DbKey)this.username);
        if (key == null) {
            return null;
        }
        PersistedUser user = (PersistedUser)this.userByUserKeyColumnFamily.get((DbKey)key);
        return user == null ? null : user.getUser().copy();
    }

    @Override
    public UserRecord getUser(String username) {
        return this.getUser(BufferUtil.wrapString((String)username));
    }

    @Override
    public void updateUser(UserRecord user) {
        this.username.wrapBuffer(user.getUsernameBuffer());
        DbForeignKey key = (DbForeignKey)this.userKeyByUsernameColumnFamily.get((DbKey)this.username);
        this.persistedUser.setUser(user);
        this.userByUserKeyColumnFamily.update((DbKey)key, (DbValue)this.persistedUser);
    }
}

