/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine;

import io.camunda.zeebe.engine.EngineConfiguration;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.processing.streamprocessor.RecordProcessorMap;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessor;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorContextImpl;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessorFactory;
import io.camunda.zeebe.engine.processing.streamprocessor.TypedRecordProcessors;
import io.camunda.zeebe.engine.processing.streamprocessor.writers.Writers;
import io.camunda.zeebe.engine.state.EventApplier;
import io.camunda.zeebe.engine.state.appliers.EventAppliers;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.processing.DbBannedInstanceState;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.error.ErrorRecord;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.ErrorIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceCreationIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceRelatedIntent;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.stream.api.ProcessingResult;
import io.camunda.zeebe.stream.api.ProcessingResultBuilder;
import io.camunda.zeebe.stream.api.RecordProcessor;
import io.camunda.zeebe.stream.api.RecordProcessorContext;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class Engine
implements RecordProcessor {
    private static final Logger LOG = Loggers.PROCESS_PROCESSOR_LOGGER;
    private static final String ERROR_MESSAGE_PROCESSOR_NOT_FOUND = "Expected to find processor for record '{}', but caught an exception. Skip this record.";
    private static final String ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED = "Expected to process record '%s' without errors, but exception occurred with message '%s'.";
    private static final EnumSet<ValueType> SUPPORTED_VALUETYPES = EnumSet.range(ValueType.JOB, ValueType.AUTHORIZATION);
    private EventApplier eventApplier;
    private RecordProcessorMap recordProcessorMap;
    private MutableProcessingState processingState;
    private final ErrorRecord errorRecord = new ErrorRecord();
    private final ProcessingResultBuilderMutex resultBuilderMutex = new ProcessingResultBuilderMutex();
    private Writers writers;
    private final TypedRecordProcessorFactory typedRecordProcessorFactory;
    private final EngineConfiguration config;

    public Engine(TypedRecordProcessorFactory typedRecordProcessorFactory, EngineConfiguration config) {
        this.typedRecordProcessorFactory = typedRecordProcessorFactory;
        this.config = config;
    }

    public void init(RecordProcessorContext recordProcessorContext) {
        this.eventApplier = new EventAppliers();
        this.writers = new Writers(this.resultBuilderMutex, this.eventApplier);
        TypedRecordProcessorContextImpl typedProcessorContext = new TypedRecordProcessorContextImpl(recordProcessorContext, this.writers, this.config);
        this.processingState = typedProcessorContext.getProcessingState();
        ((EventAppliers)this.eventApplier).registerEventAppliers(this.processingState);
        TypedRecordProcessors typedRecordProcessors = this.typedRecordProcessorFactory.createProcessors(typedProcessorContext);
        recordProcessorContext.addLifecycleListeners(typedRecordProcessors.getLifecycleListeners());
        this.recordProcessorMap = typedRecordProcessors.getRecordProcessorMap();
        recordProcessorContext.getClock().applyModification(this.processingState.getClockState().getModification());
    }

    public boolean accepts(ValueType valueType) {
        return SUPPORTED_VALUETYPES.contains(valueType);
    }

    public void replay(TypedRecord event) {
        this.eventApplier.applyState(event.getKey(), event.getIntent(), (RecordValue)event.getValue(), event.getRecordVersion());
    }

    public ProcessingResult process(TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            boolean noBanCheckNeeded;
            TypedRecordProcessor currentProcessor = null;
            TypedRecord typedCommand = record;
            try {
                currentProcessor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            if (currentProcessor == null) {
                ProcessingResult e = processingResultBuilder.build();
                return e;
            }
            boolean bl = noBanCheckNeeded = !(record.getIntent() instanceof ProcessInstanceRelatedIntent) || record.getIntent() instanceof ProcessInstanceCreationIntent;
            if (noBanCheckNeeded || !this.processingState.getBannedInstanceState().isBanned(typedCommand)) {
                currentProcessor.processRecord(record);
            }
        }
        return processingResultBuilder.build();
    }

    public ProcessingResult onProcessingError(Throwable processingException, TypedRecord record, ProcessingResultBuilder processingResultBuilder) {
        try (ProcessingResultBuilderScope scope = new ProcessingResultBuilderScope(processingResultBuilder);){
            TypedRecordProcessor.ProcessingError error;
            TypedRecord typedCommand = record;
            TypedRecordProcessor processor = null;
            try {
                processor = this.recordProcessorMap.get(typedCommand.getRecordType(), typedCommand.getValueType(), typedCommand.getIntent().value());
            }
            catch (Exception e) {
                LOG.error(ERROR_MESSAGE_PROCESSOR_NOT_FOUND, (Object)typedCommand, (Object)e);
            }
            TypedRecordProcessor.ProcessingError processingError = error = processor == null ? TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR : processor.tryHandleError(record, processingException);
            if (error == TypedRecordProcessor.ProcessingError.UNEXPECTED_ERROR) {
                TypedRecord errorRecord = this.getRejectionRecord(record);
                this.handleUnexpectedError(processingException, errorRecord);
            }
        }
        return processingResultBuilder.build();
    }

    private void handleUnexpectedError(Throwable processingException, TypedRecord record) {
        String errorMessage = String.format(ERROR_MESSAGE_PROCESSING_EXCEPTION_OCCURRED, record, processingException.getMessage());
        LOG.error(errorMessage, processingException);
        if (processingException instanceof ExceededBatchRecordSizeException) {
            this.writers.rejection().appendRejection((TypedRecord<? extends RecordValue>)record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
            this.writers.response().writeRejectionOnCommand(record, RejectionType.EXCEEDED_BATCH_RECORD_SIZE, "");
        } else {
            this.writers.rejection().appendRejection((TypedRecord<? extends RecordValue>)record, RejectionType.PROCESSING_ERROR, errorMessage);
            this.writers.response().writeRejectionOnCommand(record, RejectionType.PROCESSING_ERROR, errorMessage);
        }
        this.errorRecord.initErrorRecord(processingException, record.getPosition());
        if (DbBannedInstanceState.shouldBeBanned(record.getIntent())) {
            if (record.getValue() instanceof ProcessInstanceRelated) {
                long processInstanceKey = ((ProcessInstanceRelated)record.getValue()).getProcessInstanceKey();
                this.errorRecord.setProcessInstanceKey(processInstanceKey);
            }
            this.writers.state().appendFollowUpEvent(record.getKey(), (Intent)ErrorIntent.CREATED, (RecordValue)this.errorRecord);
        }
    }

    private TypedRecord getRejectionRecord(TypedRecord record) {
        UnifiedRecordValue unifiedRecordValue = record.getValue();
        if (unifiedRecordValue instanceof DeploymentRecord) {
            DeploymentRecord deploymentRecord = (DeploymentRecord)unifiedRecordValue;
            deploymentRecord.resetResources();
        }
        return record;
    }

    private static final class ProcessingResultBuilderMutex
    implements Supplier<ProcessingResultBuilder> {
        private ProcessingResultBuilder resultBuilder;

        private ProcessingResultBuilderMutex() {
        }

        private void setResultBuilder(ProcessingResultBuilder resultBuilder) {
            this.resultBuilder = Objects.requireNonNull(resultBuilder);
        }

        private void unsetResultBuilder() {
            this.resultBuilder = null;
        }

        @Override
        public ProcessingResultBuilder get() {
            if (this.resultBuilder == null) {
                throw new IllegalStateException("Attempt to retrieve resultBuilder out of scope.");
            }
            return this.resultBuilder;
        }
    }

    private final class ProcessingResultBuilderScope
    implements AutoCloseable {
        private ProcessingResultBuilderScope(ProcessingResultBuilder processingResultBuilder) {
            Engine.this.resultBuilderMutex.setResultBuilder(processingResultBuilder);
        }

        @Override
        public void close() {
            Engine.this.resultBuilderMutex.unsetResultBuilder();
        }
    }
}

