/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.protocol.record.value.BpmnEventType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public final class BpmnElementContextImpl
implements BpmnElementContext {
    private long elementInstanceKey;
    private ProcessInstanceRecord recordValue;
    private ProcessInstanceIntent intent;

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public long getFlowScopeKey() {
        return this.recordValue.getFlowScopeKey();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.recordValue.getProcessInstanceKey();
    }

    @Override
    public long getParentProcessInstanceKey() {
        return this.recordValue.getParentProcessInstanceKey();
    }

    @Override
    public long getParentElementInstanceKey() {
        return this.recordValue.getParentElementInstanceKey();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.recordValue.getProcessDefinitionKey();
    }

    @Override
    public int getProcessVersion() {
        return this.recordValue.getVersion();
    }

    @Override
    public DirectBuffer getBpmnProcessId() {
        return this.recordValue.getBpmnProcessIdBuffer();
    }

    @Override
    public DirectBuffer getElementId() {
        return this.recordValue.getElementIdBuffer();
    }

    @Override
    public BpmnElementType getBpmnElementType() {
        return this.recordValue.getBpmnElementType();
    }

    @Override
    public ProcessInstanceRecord getRecordValue() {
        return this.recordValue;
    }

    @Override
    public ProcessInstanceIntent getIntent() {
        return this.intent;
    }

    @Override
    public String getTenantId() {
        return this.recordValue.getTenantId();
    }

    @Override
    public BpmnEventType getBpmnEventType() {
        return this.recordValue.getBpmnEventType();
    }

    @Override
    public BpmnElementContext copy(long elementInstanceKey, ProcessInstanceRecord recordValue, ProcessInstanceIntent intent) {
        BpmnElementContextImpl copy = new BpmnElementContextImpl();
        copy.init(elementInstanceKey, recordValue, intent);
        return copy;
    }

    public void init(long elementInstanceKey, ProcessInstanceRecord recordValue, ProcessInstanceIntent intent) {
        this.elementInstanceKey = elementInstanceKey;
        this.recordValue = recordValue;
        this.intent = intent;
    }

    public String toString() {
        return "{intent=" + String.valueOf(this.intent) + ", elementId=" + BufferUtil.bufferAsString((DirectBuffer)this.getElementId()) + ", bpmnElementType=" + String.valueOf(this.getBpmnElementType()) + ", elementInstanceKey=" + this.getElementInstanceKey() + ", flowScopeKey=" + this.getFlowScopeKey() + ", processInstanceKey=" + this.getProcessInstanceKey() + ", parentProcessInstanceKey=" + this.getParentProcessInstanceKey() + ", parentElementInstanceKey=" + this.getParentElementInstanceKey() + ", bpmnProcessId=" + BufferUtil.bufferAsString((DirectBuffer)this.getBpmnProcessId()) + ", processVersion=" + this.getProcessVersion() + ", processDefinitionKey=" + this.getProcessDefinitionKey() + ", tenantId=" + this.getTenantId() + "}";
    }
}

