/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.bpmn.gateway;

import io.camunda.zeebe.engine.processing.bpmn.BpmnElementContext;
import io.camunda.zeebe.engine.processing.bpmn.BpmnElementProcessor;
import io.camunda.zeebe.engine.processing.bpmn.BpmnProcessingException;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnBehaviors;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnEventSubscriptionBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnIncidentBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnJobBehavior;
import io.camunda.zeebe.engine.processing.bpmn.behavior.BpmnStateTransitionBehavior;
import io.camunda.zeebe.engine.processing.common.Failure;
import io.camunda.zeebe.engine.processing.deployment.model.element.ExecutableEventBasedGateway;
import io.camunda.zeebe.engine.state.instance.EventTrigger;
import io.camunda.zeebe.util.Either;

public final class EventBasedGatewayProcessor
implements BpmnElementProcessor<ExecutableEventBasedGateway> {
    private final BpmnStateTransitionBehavior stateTransitionBehavior;
    private final BpmnEventSubscriptionBehavior eventSubscriptionBehavior;
    private final BpmnIncidentBehavior incidentBehavior;
    private final BpmnJobBehavior jobBehavior;

    public EventBasedGatewayProcessor(BpmnBehaviors bpmnBehaviors, BpmnStateTransitionBehavior stateTransitionBehavior) {
        this.stateTransitionBehavior = stateTransitionBehavior;
        this.eventSubscriptionBehavior = bpmnBehaviors.eventSubscriptionBehavior();
        this.incidentBehavior = bpmnBehaviors.incidentBehavior();
        this.jobBehavior = bpmnBehaviors.jobBehavior();
    }

    @Override
    public Class<ExecutableEventBasedGateway> getType() {
        return ExecutableEventBasedGateway.class;
    }

    @Override
    public Either<Failure, ?> finalizeActivation(ExecutableEventBasedGateway element, BpmnElementContext context) {
        return this.eventSubscriptionBehavior.subscribeToEvents(element, context).thenDo(ok -> this.stateTransitionBehavior.transitionToActivated(context, element.getEventType()));
    }

    @Override
    public Either<Failure, ?> onComplete(ExecutableEventBasedGateway element, BpmnElementContext context) {
        return SUCCESS.thenDo(ok -> this.eventSubscriptionBehavior.unsubscribeFromEvents(context));
    }

    @Override
    public Either<Failure, ?> finalizeCompletion(ExecutableEventBasedGateway element, BpmnElementContext context) {
        EventTrigger eventTrigger = this.eventSubscriptionBehavior.findEventTrigger(context).orElseThrow(() -> new BpmnProcessingException(context, "Expected an event trigger to complete the event-based gateway but not found."));
        return this.stateTransitionBehavior.transitionToCompleted(element, context).thenDo(completed -> this.eventSubscriptionBehavior.activateTriggeredEvent(context.getElementInstanceKey(), completed.getFlowScopeKey(), eventTrigger, (BpmnElementContext)completed));
    }

    @Override
    public void onTerminate(ExecutableEventBasedGateway element, BpmnElementContext context) {
        if (element.hasExecutionListeners()) {
            this.jobBehavior.cancelJob(context);
        }
        this.eventSubscriptionBehavior.unsubscribeFromEvents(context);
        this.incidentBehavior.resolveIncidents(context);
        BpmnElementContext terminated = this.stateTransitionBehavior.transitionToTerminated(context, element.getEventType());
        this.stateTransitionBehavior.onElementTerminated(element, terminated);
    }
}

