/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.processing.job;

import io.camunda.zeebe.engine.metrics.JobMetrics;
import io.camunda.zeebe.engine.processing.streamprocessor.CommandProcessor;
import io.camunda.zeebe.engine.state.immutable.JobState;
import io.camunda.zeebe.engine.state.immutable.ProcessingState;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.records.TypedRecord;

public final class JobCancelProcessor
implements CommandProcessor<JobRecord> {
    public static final String NO_JOB_FOUND_MESSAGE = "Expected to cancel job with key '%d', but no such job was found";
    private final JobState jobState;
    private final JobMetrics jobMetrics;

    public JobCancelProcessor(ProcessingState state, JobMetrics jobMetrics) {
        this.jobState = state.getJobState();
        this.jobMetrics = jobMetrics;
    }

    @Override
    public boolean onCommand(TypedRecord<JobRecord> command, CommandProcessor.CommandControl<JobRecord> commandControl) {
        long jobKey = command.getKey();
        JobRecord job = this.jobState.getJob(jobKey);
        if (job != null) {
            commandControl.accept((Intent)JobIntent.CANCELED, job);
            this.jobMetrics.jobCanceled(job.getType(), job.getJobKind());
        } else {
            commandControl.reject(RejectionType.NOT_FOUND, String.format(NO_JOB_FOUND_MESSAGE, jobKey));
        }
        return true;
    }
}

