/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.appliers;

import io.camunda.zeebe.engine.state.TypedEventApplier;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessingState;
import io.camunda.zeebe.engine.state.mutable.MutableUserTaskState;
import io.camunda.zeebe.protocol.impl.record.value.usertask.UserTaskRecord;
import io.camunda.zeebe.protocol.record.intent.UserTaskIntent;

public final class UserTaskCompletedApplier
implements TypedEventApplier<UserTaskIntent, UserTaskRecord> {
    private final MutableUserTaskState userTaskState;
    private final MutableElementInstanceState elementInstanceState;

    public UserTaskCompletedApplier(MutableProcessingState processingState) {
        this.userTaskState = processingState.getUserTaskState();
        this.elementInstanceState = processingState.getElementInstanceState();
    }

    @Override
    public void applyState(long key, UserTaskRecord value) {
        long scopeKey;
        ElementInstance scopeInstance;
        this.userTaskState.delete(key);
        long elementInstanceKey = value.getElementInstanceKey();
        ElementInstance elementInstance = this.elementInstanceState.getInstance(elementInstanceKey);
        if (elementInstance != null && (scopeInstance = this.elementInstanceState.getInstance(scopeKey = elementInstance.getValue().getFlowScopeKey())) != null && scopeInstance.isActive()) {
            elementInstance.setUserTaskKey(-1L);
            this.elementInstanceState.updateInstance(elementInstance);
        }
    }
}

