/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.http.restful.ws.impl;

import io.cloudevents.SpecVersion;
import io.cloudevents.core.data.BytesCloudEventData;
import io.cloudevents.core.impl.StringUtils;
import io.cloudevents.core.message.impl.BaseGenericBinaryMessageReaderImpl;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class BinaryRestfulWSMessageReaderImpl
extends BaseGenericBinaryMessageReaderImpl<String, String> {
    private final MultivaluedMap<String, String> headers;

    public BinaryRestfulWSMessageReaderImpl(SpecVersion version, MultivaluedMap<String, String> headers, byte[] body) {
        super(version, body != null && body.length > 0 ? BytesCloudEventData.wrap((byte[])body) : null);
        Objects.requireNonNull(headers);
        this.headers = headers;
    }

    protected boolean isContentTypeHeader(String key) {
        return key.equalsIgnoreCase("Content-Type");
    }

    protected boolean isCloudEventsHeader(String key) {
        return key.length() > "ce-".length() && StringUtils.startsWithIgnoreCase((String)key, (String)"ce-");
    }

    protected String toCloudEventsKey(String key) {
        return key.substring("ce-".length()).toLowerCase();
    }

    protected void forEachHeader(BiConsumer<String, String> fn) {
        this.headers.forEach((k, v) -> fn.accept((String)k, (String)v.get(0)));
    }

    protected String toCloudEventsValue(String value) {
        return value;
    }
}

