/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

public final class JsonFormatOptions {
    private final boolean forceDataBase64Serialization;
    private final boolean forceStringSerialization;
    private final boolean forceExtensionNameLowerCaseDeserialization;
    private final boolean forceIgnoreInvalidExtensionNameDeserialization;

    public JsonFormatOptions() {
        this(false, false, false, false);
    }

    JsonFormatOptions(boolean forceDataBase64Serialization, boolean forceStringSerialization, boolean forceExtensionNameLowerCaseDeserialization, boolean forceIgnoreInvalidExtensionNameDeserialization) {
        this.forceDataBase64Serialization = forceDataBase64Serialization;
        this.forceStringSerialization = forceStringSerialization;
        this.forceExtensionNameLowerCaseDeserialization = forceExtensionNameLowerCaseDeserialization;
        this.forceIgnoreInvalidExtensionNameDeserialization = forceIgnoreInvalidExtensionNameDeserialization;
    }

    public static JsonFormatOptionsBuilder builder() {
        return new JsonFormatOptionsBuilder();
    }

    public boolean isForceDataBase64Serialization() {
        return this.forceDataBase64Serialization;
    }

    public boolean isForceStringSerialization() {
        return this.forceStringSerialization;
    }

    public boolean isForceExtensionNameLowerCaseDeserialization() {
        return this.forceExtensionNameLowerCaseDeserialization;
    }

    public boolean isForceIgnoreInvalidExtensionNameDeserialization() {
        return this.forceIgnoreInvalidExtensionNameDeserialization;
    }

    public static class JsonFormatOptionsBuilder {
        private boolean forceDataBase64Serialization = false;
        private boolean forceStringSerialization = false;
        private boolean forceExtensionNameLowerCaseDeserialization = false;
        private boolean forceIgnoreInvalidExtensionNameDeserialization = false;

        public JsonFormatOptionsBuilder forceDataBase64Serialization(boolean forceDataBase64Serialization) {
            this.forceDataBase64Serialization = forceDataBase64Serialization;
            return this;
        }

        public JsonFormatOptionsBuilder forceStringSerialization(boolean forceStringSerialization) {
            this.forceStringSerialization = forceStringSerialization;
            return this;
        }

        public JsonFormatOptionsBuilder forceExtensionNameLowerCaseDeserialization(boolean forceExtensionNameLowerCaseDeserialization) {
            this.forceExtensionNameLowerCaseDeserialization = forceExtensionNameLowerCaseDeserialization;
            return this;
        }

        public JsonFormatOptionsBuilder forceIgnoreInvalidExtensionNameDeserialization(boolean forceIgnoreInvalidExtensionNameDeserialization) {
            this.forceIgnoreInvalidExtensionNameDeserialization = forceIgnoreInvalidExtensionNameDeserialization;
            return this;
        }

        public JsonFormatOptions build() {
            return new JsonFormatOptions(this.forceDataBase64Serialization, this.forceStringSerialization, this.forceExtensionNameLowerCaseDeserialization, this.forceIgnoreInvalidExtensionNameDeserialization);
        }
    }
}

