/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.formatter;

import cucumber.api.StepDefinitionReporter;
import cucumber.api.SummaryPrinter;
import cucumber.runtime.CucumberException;
import cucumber.runtime.DefaultSummaryPrinter;
import cucumber.runtime.NullSummaryPrinter;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.CucumberJSONFormatter;
import cucumber.runtime.formatter.CucumberPrettyFormatter;
import cucumber.runtime.formatter.HTMLFormatter;
import cucumber.runtime.formatter.JUnitFormatter;
import cucumber.runtime.formatter.NullFormatter;
import cucumber.runtime.formatter.ProgressFormatter;
import cucumber.runtime.formatter.RerunFormatter;
import cucumber.runtime.formatter.TestNGFormatter;
import cucumber.runtime.formatter.UsageFormatter;
import cucumber.runtime.io.URLOutputStream;
import cucumber.runtime.io.UTF8OutputStreamWriter;
import gherkin.formatter.Formatter;
import gherkin.formatter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PluginFactory {
    private final Class[] CTOR_ARGS = new Class[]{null, Appendable.class, URI.class, URL.class, File.class};
    private static final Map<String, Class> PLUGIN_CLASSES = new HashMap<String, Class>(){
        {
            this.put("null", NullFormatter.class);
            this.put("junit", JUnitFormatter.class);
            this.put("testng", TestNGFormatter.class);
            this.put("html", HTMLFormatter.class);
            this.put("pretty", CucumberPrettyFormatter.class);
            this.put("progress", ProgressFormatter.class);
            this.put("json", CucumberJSONFormatter.class);
            this.put("usage", UsageFormatter.class);
            this.put("rerun", RerunFormatter.class);
            this.put("default_summary", DefaultSummaryPrinter.class);
            this.put("null_summary", NullSummaryPrinter.class);
        }
    };
    private static final Pattern PLUGIN_WITH_FILE_PATTERN = Pattern.compile("([^:]+):(.*)");
    private String defaultOutFormatter = null;
    private Appendable defaultOut = new PrintStream(System.out){

        @Override
        public void close() {
        }
    };

    public Object create(String pluginString) {
        String pluginName;
        Matcher pluginWithFile = PLUGIN_WITH_FILE_PATTERN.matcher(pluginString);
        String path = null;
        if (pluginWithFile.matches()) {
            pluginName = pluginWithFile.group(1);
            path = pluginWithFile.group(2);
        } else {
            pluginName = pluginString;
        }
        Class pluginClass = PluginFactory.pluginClass(pluginName);
        try {
            return this.instantiate(pluginString, pluginClass, path);
        }
        catch (IOException e) {
            throw new CucumberException(e);
        }
        catch (URISyntaxException e) {
            throw new CucumberException(e);
        }
    }

    private <T> T instantiate(String pluginString, Class<T> pluginClass, String pathOrUrl) throws IOException, URISyntaxException {
        for (Class ctorArgClass : this.CTOR_ARGS) {
            Constructor<T> constructor = this.findConstructor(pluginClass, ctorArgClass);
            if (constructor == null) continue;
            Object ctorArg = this.convertOrNull(pathOrUrl, ctorArgClass, pluginString);
            try {
                if (ctorArgClass == null) {
                    return constructor.newInstance(new Object[0]);
                }
                if (ctorArg == null) {
                    throw new CucumberException(String.format("You must supply an output argument to %s. Like so: %s:output", pluginString, pluginString));
                }
                return constructor.newInstance(ctorArg);
            }
            catch (InstantiationException e) {
                throw new CucumberException(e);
            }
            catch (IllegalAccessException e) {
                throw new CucumberException(e);
            }
            catch (InvocationTargetException e) {
                throw new CucumberException(e.getTargetException());
            }
        }
        throw new CucumberException(String.format("%s must have a constructor that is either empty or a single arg of one of: %s", pluginClass, Arrays.asList(this.CTOR_ARGS)));
    }

    private Object convertOrNull(String pathOrUrl, Class ctorArgClass, String formatterString) throws IOException, URISyntaxException {
        if (ctorArgClass == null) {
            return null;
        }
        if (ctorArgClass.equals(URI.class) && pathOrUrl != null) {
            return new URI(pathOrUrl);
        }
        if (ctorArgClass.equals(URL.class) && pathOrUrl != null) {
            return Utils.toURL(pathOrUrl);
        }
        if (ctorArgClass.equals(File.class) && pathOrUrl != null) {
            return new File(pathOrUrl);
        }
        if (ctorArgClass.equals(Appendable.class)) {
            if (pathOrUrl != null) {
                return new UTF8OutputStreamWriter(new URLOutputStream(Utils.toURL(pathOrUrl)));
            }
            return this.defaultOutOrFailIfAlreadyUsed(formatterString);
        }
        return null;
    }

    private <T> Constructor<T> findConstructor(Class<T> pluginClass, Class<?> ctorArgClass) {
        try {
            if (ctorArgClass == null) {
                return pluginClass.getConstructor(new Class[0]);
            }
            return pluginClass.getConstructor(ctorArgClass);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static <T> Class<T> pluginClass(String pluginName) {
        Class<T> pluginClass = PLUGIN_CLASSES.get(pluginName);
        if (pluginClass == null) {
            pluginClass = PluginFactory.loadClass(pluginName);
        }
        return pluginClass;
    }

    private static <T> Class<T> loadClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CucumberException("Couldn't load plugin class: " + className, e);
        }
    }

    private Appendable defaultOutOrFailIfAlreadyUsed(String formatterString) {
        try {
            if (this.defaultOut != null) {
                this.defaultOutFormatter = formatterString;
                Appendable appendable = this.defaultOut;
                return appendable;
            }
            throw new CucumberException("Only one formatter can use STDOUT, now both " + this.defaultOutFormatter + " and " + formatterString + " use it. If you use more than one formatter you must specify output path with PLUGIN:PATH_OR_URL");
        }
        finally {
            this.defaultOut = null;
        }
    }

    public static boolean isFormatterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return Formatter.class.isAssignableFrom(pluginClass) || Reporter.class.isAssignableFrom(pluginClass);
    }

    public static boolean isStepDefinitionResporterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return StepDefinitionReporter.class.isAssignableFrom(pluginClass);
    }

    public static boolean isSummaryPrinterName(String name) {
        Class pluginClass = PluginFactory.getPluginClass(name);
        return SummaryPrinter.class.isAssignableFrom(pluginClass);
    }

    private static Class getPluginClass(String name) {
        Matcher pluginWithFile = PLUGIN_WITH_FILE_PATTERN.matcher(name);
        String pluginName = pluginWithFile.matches() ? pluginWithFile.group(1) : name;
        return PluginFactory.pluginClass(pluginName);
    }
}

