/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import cucumber.api.DataTable;
import cucumber.deps.difflib.Delta;
import cucumber.deps.difflib.DiffUtils;
import cucumber.deps.difflib.Patch;
import cucumber.runtime.table.DataTableDiff;
import cucumber.runtime.table.DiffableRow;
import cucumber.runtime.table.TableDiffException;
import gherkin.pickles.PickleCell;
import gherkin.pickles.PickleRow;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableDiffer {
    private final DataTable from;
    private final DataTable to;

    public TableDiffer(DataTable fromTable, DataTable toTable) {
        this.checkColumns(fromTable, toTable);
        this.from = fromTable;
        this.to = toTable;
    }

    private void checkColumns(DataTable a, DataTable b) {
        if (a.topCells().size() != b.topCells().size() && !b.topCells().isEmpty()) {
            throw new IllegalArgumentException("Tables must have equal number of columns:\n" + a + "\n" + b);
        }
    }

    public void calculateDiffs() throws TableDiffException {
        Patch patch = DiffUtils.diff(this.from.diffableRows(), this.to.diffableRows());
        List deltas = patch.getDeltas();
        if (!deltas.isEmpty()) {
            Map<Integer, Delta> deltasByLine = this.createDeltasByLine(deltas);
            throw new TableDiffException(this.from, this.to, this.createTableDiff(deltasByLine));
        }
    }

    public void calculateUnorderedDiffs() throws TableDiffException {
        boolean isDifferent = false;
        ArrayList<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>> diffTableRows = new ArrayList<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>>();
        ArrayList<List<String>> missingRow = new ArrayList<List<String>>();
        ArrayList<List<String>> extraRows = new ArrayList<List<String>>();
        extraRows.addAll(this.to.raw());
        for (PickleRow pickleRow : this.from.getPickleRows()) {
            if (!this.to.raw().contains(this.getCellValues(pickleRow))) {
                missingRow.add(this.getCellValues(pickleRow));
                diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(new PickleRow(pickleRow.getCells()), DataTableDiff.DiffType.DELETE));
                isDifferent = true;
                continue;
            }
            diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(new PickleRow(pickleRow.getCells()), DataTableDiff.DiffType.NONE));
            extraRows.remove(this.getCellValues(pickleRow));
        }
        for (List list : extraRows) {
            diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(new PickleRow(this.convertToPickleCells(list)), DataTableDiff.DiffType.INSERT));
            isDifferent = true;
        }
        if (isDifferent) {
            throw new TableDiffException(this.from, this.to, DataTableDiff.create(diffTableRows, this.from.getTableConverter()));
        }
    }

    private List<PickleCell> convertToPickleCells(List<String> e) {
        ArrayList<PickleCell> cells = new ArrayList<PickleCell>(e.size());
        for (String value : e) {
            cells.add(new PickleCell(null, value));
        }
        return cells;
    }

    private List<String> getCellValues(PickleRow r) {
        ArrayList<String> values = new ArrayList<String>(r.getCells().size());
        for (PickleCell cell : r.getCells()) {
            values.add(cell.getValue());
        }
        return values;
    }

    private Map<Integer, Delta> createDeltasByLine(List<Delta> deltas) {
        HashMap<Integer, Delta> deltasByLine = new HashMap<Integer, Delta>();
        for (Delta delta : deltas) {
            deltasByLine.put(delta.getOriginal().getPosition(), delta);
        }
        return deltasByLine;
    }

    private DataTable createTableDiff(Map<Integer, Delta> deltasByLine) {
        ArrayList<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>> diffTableRows = new ArrayList<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>>();
        List<List<String>> rows = this.from.raw();
        for (int i = 0; i < rows.size(); ++i) {
            Delta delta = deltasByLine.get(i);
            if (delta == null) {
                diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(this.from.getPickleRows().get(i), DataTableDiff.DiffType.NONE));
                continue;
            }
            this.addRowsToTableDiff(diffTableRows, delta);
            if (delta.getType() == Delta.TYPE.CHANGE || delta.getType() == Delta.TYPE.DELETE) {
                i += delta.getOriginal().getLines().size() - 1;
                continue;
            }
            diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(this.from.getPickleRows().get(i), DataTableDiff.DiffType.NONE));
        }
        Delta remainingDelta = deltasByLine.get(rows.size());
        if (remainingDelta != null) {
            this.addRowsToTableDiff(diffTableRows, remainingDelta);
        }
        return DataTableDiff.create(diffTableRows, this.from.getTableConverter());
    }

    private void addRowsToTableDiff(List<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>> diffTableRows, Delta delta) {
        this.markChangedAndDeletedRowsInOriginalAsMissing(diffTableRows, delta);
        this.markChangedAndInsertedRowsInRevisedAsNew(diffTableRows, delta);
    }

    private void markChangedAndDeletedRowsInOriginalAsMissing(List<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>> diffTableRows, Delta delta) {
        List deletedLines = delta.getOriginal().getLines();
        for (DiffableRow row : deletedLines) {
            diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(new PickleRow(row.row.getCells()), DataTableDiff.DiffType.DELETE));
        }
    }

    private void markChangedAndInsertedRowsInRevisedAsNew(List<AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>> diffTableRows, Delta delta) {
        List insertedLines = delta.getRevised().getLines();
        for (DiffableRow row : insertedLines) {
            diffTableRows.add(new AbstractMap.SimpleEntry<PickleRow, DataTableDiff.DiffType>(new PickleRow(row.row.getCells()), DataTableDiff.DiffType.INSERT));
        }
    }
}

