/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runner;

import cucumber.api.HookType;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.TestCase;
import cucumber.api.TestStep;
import cucumber.api.event.SnippetsSuggestedEvent;
import cucumber.runner.EventBus;
import cucumber.runner.PickleTestStep;
import cucumber.runner.UndefinedStepException;
import cucumber.runner.UnskipableStep;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.AmbiguousStepDefinitionsMatch;
import cucumber.runtime.Backend;
import cucumber.runtime.FailedStepInstantiationMatch;
import cucumber.runtime.Glue;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.HookDefinitionMatch;
import cucumber.runtime.RuntimeOptions;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepDefinitionMatch;
import cucumber.runtime.UnreportedStepExecutor;
import gherkin.events.PickleEvent;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleStep;
import gherkin.pickles.PickleString;
import gherkin.pickles.PickleTable;
import gherkin.pickles.PickleTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Runner
implements UnreportedStepExecutor {
    private final Glue glue;
    private final EventBus bus;
    private final Collection<? extends Backend> backends;
    private final RuntimeOptions runtimeOptions;

    public Runner(Glue glue, EventBus bus, Collection<? extends Backend> backends, RuntimeOptions runtimeOptions) {
        this.glue = glue;
        this.bus = bus;
        this.runtimeOptions = runtimeOptions;
        this.backends = backends;
        for (Backend backend : backends) {
            backend.loadGlue(glue, runtimeOptions.getGlue());
            backend.setUnreportedStepExecutor(this);
        }
    }

    @Override
    public void runUnreportedStep(String featurePath, String language, String stepName, int line, List<PickleRow> dataTableRows, PickleString docString) throws Throwable {
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (dataTableRows != null && !dataTableRows.isEmpty()) {
            arguments.add(new PickleTable(dataTableRows));
        } else if (docString != null) {
            arguments.add(docString);
        }
        PickleStep step = new PickleStep(stepName, arguments, Collections.emptyList());
        StepDefinitionMatch match = this.glue.stepDefinitionMatch(featurePath, step);
        if (match == null) {
            UndefinedStepException error = new UndefinedStepException(step);
            StackTraceElement[] originalTrace = error.getStackTrace();
            StackTraceElement[] newTrace = new StackTraceElement[originalTrace.length + 1];
            newTrace[0] = new StackTraceElement("\u273d", "StepDefinition", featurePath, line);
            System.arraycopy(originalTrace, 0, newTrace, 1, originalTrace.length);
            error.setStackTrace(newTrace);
            throw error;
        }
        match.runStep(language, null);
    }

    public void runPickle(PickleEvent pickle) {
        this.buildBackendWorlds();
        TestCase testCase = this.createTestCaseForPickle(pickle);
        testCase.run(this.bus);
        this.disposeBackendWorlds();
    }

    public Glue getGlue() {
        return this.glue;
    }

    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        this.glue.reportStepDefinitions(stepDefinitionReporter);
    }

    private TestCase createTestCaseForPickle(PickleEvent pickleEvent) {
        ArrayList<TestStep> testSteps = new ArrayList<TestStep>();
        if (!pickleEvent.pickle.getSteps().isEmpty()) {
            if (!this.runtimeOptions.isDryRun()) {
                this.addTestStepsForBeforeHooks(testSteps, pickleEvent.pickle.getTags());
            }
            this.addTestStepsForPickleSteps(testSteps, pickleEvent);
            if (!this.runtimeOptions.isDryRun()) {
                this.addTestStepsForAfterHooks(testSteps, pickleEvent.pickle.getTags());
            }
        }
        return new TestCase(testSteps, pickleEvent, this.runtimeOptions.isDryRun());
    }

    private void addTestStepsForPickleSteps(List<TestStep> testSteps, PickleEvent pickleEvent) {
        for (PickleStep step : pickleEvent.pickle.getSteps()) {
            StepDefinitionMatch match;
            try {
                match = this.glue.stepDefinitionMatch(pickleEvent.uri, step);
                if (match == null) {
                    ArrayList<String> snippets = new ArrayList<String>();
                    for (Backend backend : this.backends) {
                        String snippet = backend.getSnippet(step, "**KEYWORD**", this.runtimeOptions.getSnippetType().getFunctionNameGenerator());
                        if (snippet == null) continue;
                        snippets.add(snippet);
                    }
                    if (!snippets.isEmpty()) {
                        this.bus.send(new SnippetsSuggestedEvent(this.bus.getTime(), pickleEvent.uri, step.getLocations(), snippets));
                    }
                    match = new UndefinedStepDefinitionMatch(step);
                }
            }
            catch (AmbiguousStepDefinitionsException e) {
                match = new AmbiguousStepDefinitionsMatch(pickleEvent.uri, step, e);
            }
            catch (Throwable t) {
                match = new FailedStepInstantiationMatch(pickleEvent.uri, step, t);
            }
            testSteps.add(new PickleTestStep(pickleEvent.uri, step, match));
        }
    }

    private void addTestStepsForBeforeHooks(List<TestStep> testSteps, List<PickleTag> tags) {
        this.addTestStepsForHooks(testSteps, tags, this.glue.getBeforeHooks(), HookType.Before);
    }

    private void addTestStepsForAfterHooks(List<TestStep> testSteps, List<PickleTag> tags) {
        this.addTestStepsForHooks(testSteps, tags, this.glue.getAfterHooks(), HookType.After);
    }

    private void addTestStepsForHooks(List<TestStep> testSteps, List<PickleTag> tags, List<HookDefinition> hooks, HookType hookType) {
        for (HookDefinition hook : hooks) {
            if (!hook.matches(tags)) continue;
            UnskipableStep testStep = new UnskipableStep(hookType, new HookDefinitionMatch(hook));
            testSteps.add(testStep);
        }
    }

    private void buildBackendWorlds() {
        this.runtimeOptions.getPlugins();
        for (Backend backend : this.backends) {
            backend.buildWorld();
        }
    }

    private void disposeBackendWorlds() {
        for (Backend backend : this.backends) {
            backend.disposeWorld();
        }
    }
}

