/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.StepDefinitionReporter;
import cucumber.runtime.AmbiguousStepDefinitionsException;
import cucumber.runtime.Argument;
import cucumber.runtime.DuplicateStepDefinitionException;
import cucumber.runtime.Glue;
import cucumber.runtime.HookComparator;
import cucumber.runtime.HookDefinition;
import cucumber.runtime.StepDefinition;
import cucumber.runtime.StepDefinitionMatch;
import cucumber.runtime.UndefinedStepsTracker;
import cucumber.runtime.xstream.LocalizedXStreams;
import gherkin.pickles.PickleStep;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RuntimeGlue
implements Glue {
    final Map<String, StepDefinition> stepDefinitionsByPattern = new TreeMap<String, StepDefinition>();
    final List<HookDefinition> beforeHooks = new ArrayList<HookDefinition>();
    final List<HookDefinition> afterHooks = new ArrayList<HookDefinition>();
    final Map<String, CacheEntry> matchedStepDefinitionsCache = new HashMap<String, CacheEntry>();
    private final LocalizedXStreams localizedXStreams;

    public RuntimeGlue(LocalizedXStreams localizedXStreams) {
        this(null, localizedXStreams);
    }

    @Deprecated
    public RuntimeGlue(UndefinedStepsTracker tracker, LocalizedXStreams localizedXStreams) {
        this.localizedXStreams = localizedXStreams;
    }

    @Override
    public void addStepDefinition(StepDefinition stepDefinition) {
        StepDefinition previous = this.stepDefinitionsByPattern.get(stepDefinition.getPattern());
        if (previous != null) {
            throw new DuplicateStepDefinitionException(previous, stepDefinition);
        }
        this.stepDefinitionsByPattern.put(stepDefinition.getPattern(), stepDefinition);
    }

    @Override
    public void addBeforeHook(HookDefinition hookDefinition) {
        this.beforeHooks.add(hookDefinition);
        Collections.sort(this.beforeHooks, new HookComparator(true));
    }

    @Override
    public void addAfterHook(HookDefinition hookDefinition) {
        this.afterHooks.add(hookDefinition);
        Collections.sort(this.afterHooks, new HookComparator(false));
    }

    @Override
    public List<HookDefinition> getBeforeHooks() {
        return this.beforeHooks;
    }

    @Override
    public List<HookDefinition> getAfterHooks() {
        return this.afterHooks;
    }

    @Override
    public StepDefinitionMatch stepDefinitionMatch(String featurePath, PickleStep step) {
        String stepText = step.getText();
        CacheEntry cacheEntry = this.matchedStepDefinitionsCache.get(stepText);
        if (cacheEntry != null) {
            return new StepDefinitionMatch(cacheEntry.arguments, cacheEntry.stepDefinition, featurePath, step, this.localizedXStreams);
        }
        List<StepDefinitionMatch> matches = this.stepDefinitionMatches(featurePath, step);
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() == 1) {
            StepDefinitionMatch match = matches.get(0);
            this.matchedStepDefinitionsCache.put(stepText, new CacheEntry(match.getStepDefinition(), match.getArguments()));
            return match;
        }
        throw new AmbiguousStepDefinitionsException(step, matches);
    }

    private List<StepDefinitionMatch> stepDefinitionMatches(String featurePath, PickleStep step) {
        ArrayList<StepDefinitionMatch> result = new ArrayList<StepDefinitionMatch>();
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            List<Argument> arguments = stepDefinition.matchedArguments(step);
            if (arguments == null) continue;
            result.add(new StepDefinitionMatch(arguments, stepDefinition, featurePath, step, this.localizedXStreams));
        }
        return result;
    }

    @Override
    public void reportStepDefinitions(StepDefinitionReporter stepDefinitionReporter) {
        for (StepDefinition stepDefinition : this.stepDefinitionsByPattern.values()) {
            stepDefinitionReporter.stepDefinition(stepDefinition);
        }
    }

    @Override
    public void removeScenarioScopedGlue() {
        this.removeScenarioScopedHooks(this.beforeHooks);
        this.removeScenarioScopedHooks(this.afterHooks);
        this.removeScenarioScopedStepdefs();
    }

    private void removeScenarioScopedHooks(List<HookDefinition> beforeHooks1) {
        Iterator<HookDefinition> hookIterator = beforeHooks1.iterator();
        while (hookIterator.hasNext()) {
            HookDefinition hook = hookIterator.next();
            if (!hook.isScenarioScoped()) continue;
            hookIterator.remove();
        }
    }

    private void removeScenarioScopedStepdefs() {
        Iterator<Map.Entry<String, StepDefinition>> stepdefs = this.stepDefinitionsByPattern.entrySet().iterator();
        while (stepdefs.hasNext()) {
            StepDefinition stepDefinition = stepdefs.next().getValue();
            if (!stepDefinition.isScenarioScoped()) continue;
            stepdefs.remove();
        }
        Iterator<Map.Entry<String, CacheEntry>> cachedStepDefs = this.matchedStepDefinitionsCache.entrySet().iterator();
        while (cachedStepDefs.hasNext()) {
            StepDefinition stepDefinition = cachedStepDefs.next().getValue().stepDefinition;
            if (!stepDefinition.isScenarioScoped()) continue;
            cachedStepDefs.remove();
        }
    }

    static final class CacheEntry {
        StepDefinition stepDefinition;
        List<Argument> arguments;

        private CacheEntry(StepDefinition stepDefinition, List<Argument> arguments) {
            this.stepDefinition = stepDefinition;
            this.arguments = arguments;
        }
    }
}

