/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime.table;

import cucumber.api.DataTable;
import cucumber.api.TableConverter;
import cucumber.runtime.table.DiffTablePrinter;
import cucumber.runtime.table.TablePrinter;
import gherkin.pickles.PickleRow;
import gherkin.pickles.PickleTable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;

public class DataTableDiff
extends DataTable {
    private List<DiffType> diffTypes;

    public static DataTableDiff create(List<AbstractMap.SimpleEntry<PickleRow, DiffType>> diffTableRows, TableConverter tableConverter) {
        ArrayList<PickleRow> rows = new ArrayList<PickleRow>(diffTableRows.size());
        ArrayList<DiffType> diffTypes = new ArrayList<DiffType>(diffTableRows.size());
        for (AbstractMap.SimpleEntry<PickleRow, DiffType> row : diffTableRows) {
            rows.add(row.getKey());
            diffTypes.add(row.getValue());
        }
        return new DataTableDiff(new PickleTable(rows), diffTypes, tableConverter);
    }

    public DataTableDiff(PickleTable pickleTable, List<DiffType> diffTypes, TableConverter tableConverter) {
        super(pickleTable, tableConverter);
        this.diffTypes = diffTypes;
    }

    @Override
    protected TablePrinter createTablePrinter() {
        return new DiffTablePrinter(this.diffTypes);
    }

    public static enum DiffType {
        NONE,
        DELETE,
        INSERT;

    }
}

