/*
 * Decompiled with CFR 0.152.
 */
package cucumber.runtime;

import cucumber.api.Plugin;
import cucumber.api.SnippetType;
import cucumber.api.StepDefinitionReporter;
import cucumber.api.event.EventListener;
import cucumber.api.event.TestRunStarted;
import cucumber.api.formatter.ColorAware;
import cucumber.api.formatter.Formatter;
import cucumber.api.formatter.StrictAware;
import cucumber.runner.EventBus;
import cucumber.runtime.CucumberException;
import cucumber.runtime.Env;
import cucumber.runtime.Shellwords;
import cucumber.runtime.Utils;
import cucumber.runtime.formatter.PluginFactory;
import cucumber.runtime.io.ResourceLoader;
import cucumber.runtime.model.CucumberFeature;
import cucumber.runtime.model.PathWithLines;
import cucumber.util.FixJava;
import cucumber.util.Mapper;
import gherkin.GherkinDialect;
import gherkin.GherkinDialectProvider;
import io.cucumber.datatable.DataTable;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.regex.Pattern;

public class RuntimeOptions {
    public static final String VERSION = ResourceBundle.getBundle("cucumber.version").getString("cucumber-jvm.version");
    public static final String USAGE_RESOURCE = "/cucumber/api/cli/USAGE.txt";
    static String usageText;
    private static final Mapper<String, String> QUOTE_MAPPER;
    private static final Mapper<String, String> CODE_KEYWORD_MAPPER;
    private final List<String> glue = new ArrayList<String>();
    private final List<String> tagFilters = new ArrayList<String>();
    private final List<Pattern> nameFilters = new ArrayList<Pattern>();
    private final Map<String, List<Long>> lineFilters = new HashMap<String, List<Long>>();
    private final List<String> featurePaths = new ArrayList<String>();
    private final List<String> pluginFormatterNames = new ArrayList<String>();
    private final List<String> pluginStepDefinitionReporterNames = new ArrayList<String>();
    private final List<String> pluginSummaryPrinterNames = new ArrayList<String>();
    private final List<String> junitOptions = new ArrayList<String>();
    private final PluginFactory pluginFactory;
    private final List<Plugin> plugins = new ArrayList<Plugin>();
    private boolean dryRun;
    private boolean strict = false;
    private boolean monochrome = false;
    private SnippetType snippetType = SnippetType.UNDERSCORE;
    private boolean pluginNamesInstantiated;
    private EventBus bus;

    public RuntimeOptions(String argv) {
        this(new PluginFactory(), Shellwords.parse(argv));
    }

    public RuntimeOptions(List<String> argv) {
        this(new PluginFactory(), argv);
    }

    public RuntimeOptions(Env env, List<String> argv) {
        this(env, new PluginFactory(), argv);
    }

    public RuntimeOptions(PluginFactory pluginFactory, List<String> argv) {
        this(Env.INSTANCE, pluginFactory, argv);
    }

    public RuntimeOptions(Env env, PluginFactory pluginFactory, List<String> argv) {
        this.pluginFactory = pluginFactory;
        argv = new ArrayList<String>(argv);
        this.parse(argv);
        String cucumberOptionsFromEnv = env.get("cucumber.options");
        if (cucumberOptionsFromEnv != null) {
            this.parse(Shellwords.parse(cucumberOptionsFromEnv));
        }
        if (this.pluginFormatterNames.isEmpty()) {
            this.pluginFormatterNames.add("progress");
        }
        if (this.pluginSummaryPrinterNames.isEmpty()) {
            this.pluginSummaryPrinterNames.add("default_summary");
        }
    }

    public RuntimeOptions noSummaryPrinter() {
        this.pluginSummaryPrinterNames.clear();
        return this;
    }

    private void parse(List<String> args) {
        ArrayList<String> parsedTagFilters = new ArrayList<String>();
        ArrayList<Pattern> parsedNameFilters = new ArrayList<Pattern>();
        HashMap<String, List<Long>> parsedLineFilters = new HashMap<String, List<Long>>();
        ArrayList<String> parsedFeaturePaths = new ArrayList<String>();
        ArrayList<String> parsedGlue = new ArrayList<String>();
        ParsedPluginData parsedPluginData = new ParsedPluginData();
        ArrayList<String> parsedJunitOptions = new ArrayList<String>();
        while (!args.isEmpty()) {
            String[] nextArg;
            String arg = args.remove(0).trim();
            if (arg.equals("--help") || arg.equals("-h")) {
                this.printUsage();
                System.exit(0);
                continue;
            }
            if (arg.equals("--version") || arg.equals("-v")) {
                System.out.println(VERSION);
                System.exit(0);
                continue;
            }
            if (arg.equals("--i18n")) {
                nextArg = args.remove(0);
                System.exit(this.printI18n((String)nextArg));
                continue;
            }
            if (arg.equals("--glue") || arg.equals("-g")) {
                String gluePath = args.remove(0);
                parsedGlue.add(gluePath);
                continue;
            }
            if (arg.equals("--tags") || arg.equals("-t")) {
                parsedTagFilters.add(args.remove(0));
                continue;
            }
            if (arg.equals("--plugin") || arg.equals("--add-plugin") || arg.equals("-p")) {
                parsedPluginData.addPluginName(args.remove(0), arg.equals("--add-plugin"));
                continue;
            }
            if (arg.equals("--no-dry-run") || arg.equals("--dry-run") || arg.equals("-d")) {
                this.dryRun = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-strict") || arg.equals("--strict") || arg.equals("-s")) {
                this.strict = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--no-monochrome") || arg.equals("--monochrome") || arg.equals("-m")) {
                this.monochrome = !arg.startsWith("--no-");
                continue;
            }
            if (arg.equals("--snippets")) {
                nextArg = args.remove(0);
                this.snippetType = SnippetType.fromString((String)nextArg);
                continue;
            }
            if (arg.equals("--name") || arg.equals("-n")) {
                nextArg = args.remove(0);
                Pattern patternFilter = Pattern.compile((String)nextArg);
                parsedNameFilters.add(patternFilter);
                continue;
            }
            if (arg.startsWith("--junit,")) {
                for (String option : arg.substring("--junit,".length()).split(",")) {
                    parsedJunitOptions.add(option);
                }
                continue;
            }
            if (arg.startsWith("-")) {
                this.printUsage();
                throw new CucumberException("Unknown option: " + arg);
            }
            PathWithLines pathWithLines = new PathWithLines(arg);
            parsedFeaturePaths.add(pathWithLines.path);
            if (pathWithLines.lines.isEmpty()) continue;
            String key = pathWithLines.path.replace("classpath:", "");
            this.addLineFilters(parsedLineFilters, key, pathWithLines.lines);
        }
        if (!parsedTagFilters.isEmpty() || !parsedNameFilters.isEmpty() || !parsedLineFilters.isEmpty() || this.haveLineFilters(parsedFeaturePaths)) {
            this.tagFilters.clear();
            this.tagFilters.addAll(parsedTagFilters);
            this.nameFilters.clear();
            this.nameFilters.addAll(parsedNameFilters);
            this.lineFilters.clear();
            for (String path : parsedLineFilters.keySet()) {
                this.lineFilters.put(path, (List<Long>)parsedLineFilters.get(path));
            }
        }
        if (!parsedFeaturePaths.isEmpty()) {
            this.featurePaths.clear();
            this.featurePaths.addAll(parsedFeaturePaths);
        }
        if (!parsedGlue.isEmpty()) {
            this.glue.clear();
            this.glue.addAll(parsedGlue);
        }
        if (!parsedJunitOptions.isEmpty()) {
            this.junitOptions.clear();
            this.junitOptions.addAll(parsedJunitOptions);
        }
        parsedPluginData.updatePluginFormatterNames(this.pluginFormatterNames);
        parsedPluginData.updatePluginStepDefinitionReporterNames(this.pluginStepDefinitionReporterNames);
        parsedPluginData.updatePluginSummaryPrinterNames(this.pluginSummaryPrinterNames);
    }

    private void addLineFilters(Map<String, List<Long>> parsedLineFilters, String key, List<Long> lines) {
        if (parsedLineFilters.containsKey(key)) {
            parsedLineFilters.get(key).addAll(lines);
        } else {
            parsedLineFilters.put(key, lines);
        }
    }

    private boolean haveLineFilters(List<String> parsedFeaturePaths) {
        for (String pathName : parsedFeaturePaths) {
            if (!pathName.startsWith("@") && !PathWithLines.hasLineFilters(pathName)) continue;
            return true;
        }
        return false;
    }

    private void printUsage() {
        RuntimeOptions.loadUsageTextIfNeeded();
        System.out.println(usageText);
    }

    static void loadUsageTextIfNeeded() {
        if (usageText == null) {
            try {
                InputStreamReader reader = new InputStreamReader(FixJava.class.getResourceAsStream(USAGE_RESOURCE), "UTF-8");
                usageText = FixJava.readReader(reader);
            }
            catch (Exception e) {
                usageText = "Could not load usage text: " + e.toString();
            }
        }
    }

    private int printI18n(String language) {
        GherkinDialectProvider dialectProvider = new GherkinDialectProvider();
        List languages = dialectProvider.getLanguages();
        if (language.equalsIgnoreCase("help")) {
            for (String code : languages) {
                System.out.println(code);
            }
            return 0;
        }
        if (languages.contains(language)) {
            return this.printKeywordsFor(dialectProvider.getDialect(language, null));
        }
        System.err.println("Unrecognised ISO language code");
        return 1;
    }

    private int printKeywordsFor(GherkinDialect dialect) {
        StringBuilder builder = new StringBuilder();
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        this.addKeywordRow(table, "feature", dialect.getFeatureKeywords());
        this.addKeywordRow(table, "background", dialect.getBackgroundKeywords());
        this.addKeywordRow(table, "scenario", dialect.getScenarioKeywords());
        this.addKeywordRow(table, "scenario outline", dialect.getScenarioOutlineKeywords());
        this.addKeywordRow(table, "examples", dialect.getExamplesKeywords());
        this.addKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addKeywordRow(table, "then", dialect.getThenKeywords());
        this.addKeywordRow(table, "and", dialect.getAndKeywords());
        this.addKeywordRow(table, "but", dialect.getButKeywords());
        this.addCodeKeywordRow(table, "given", dialect.getGivenKeywords());
        this.addCodeKeywordRow(table, "when", dialect.getWhenKeywords());
        this.addCodeKeywordRow(table, "then", dialect.getThenKeywords());
        this.addCodeKeywordRow(table, "and", dialect.getAndKeywords());
        this.addCodeKeywordRow(table, "but", dialect.getButKeywords());
        DataTable.create(table).print(builder);
        System.out.println(builder.toString());
        return 0;
    }

    private void addCodeKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        ArrayList<String> codeKeywordList = new ArrayList<String>(keywords);
        codeKeywordList.remove("* ");
        this.addKeywordRow(table, key + " (code)", FixJava.map(codeKeywordList, CODE_KEYWORD_MAPPER));
    }

    private void addKeywordRow(List<List<String>> table, String key, List<String> keywords) {
        List<String> cells = Arrays.asList(key, FixJava.join(FixJava.map(keywords, QUOTE_MAPPER), ", "));
        table.add(cells);
    }

    public List<CucumberFeature> cucumberFeatures(ResourceLoader resourceLoader, EventBus bus) {
        List<CucumberFeature> features = CucumberFeature.load(resourceLoader, this.featurePaths, System.out);
        this.getPlugins();
        bus.send(new TestRunStarted(bus.getTime()));
        for (CucumberFeature feature : features) {
            feature.sendTestSourceRead(bus);
        }
        return features;
    }

    public List<Plugin> getPlugins() {
        if (!this.pluginNamesInstantiated) {
            Plugin plugin;
            for (String pluginName : this.pluginFormatterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.addPlugin(plugin);
            }
            for (String pluginName : this.pluginStepDefinitionReporterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.addPlugin(plugin);
            }
            for (String pluginName : this.pluginSummaryPrinterNames) {
                plugin = this.pluginFactory.create(pluginName);
                this.addPlugin(plugin);
            }
            this.pluginNamesInstantiated = true;
        }
        return this.plugins;
    }

    public Formatter formatter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, Formatter.class);
    }

    public StepDefinitionReporter stepDefinitionReporter(ClassLoader classLoader) {
        return this.pluginProxy(classLoader, StepDefinitionReporter.class);
    }

    private <T> T pluginProxy(ClassLoader classLoader, final Class<T> type) {
        Object proxy = Proxy.newProxyInstance(classLoader, new Class[]{type}, new InvocationHandler(){

            @Override
            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                for (Plugin plugin : RuntimeOptions.this.getPlugins()) {
                    if (!type.isInstance(plugin)) continue;
                    try {
                        Utils.invoke(plugin, method, 0L, args);
                    }
                    catch (Throwable t) {
                        if (method.getName().equals("startOfScenarioLifeCycle") || method.getName().equals("endOfScenarioLifeCycle")) continue;
                        throw t;
                    }
                }
                return null;
            }
        });
        return type.cast(proxy);
    }

    private void setMonochromeOnColorAwarePlugins(Object plugin) {
        if (plugin instanceof ColorAware) {
            ColorAware colorAware = (ColorAware)plugin;
            colorAware.setMonochrome(this.monochrome);
        }
    }

    private void setStrictOnStrictAwarePlugins(Object plugin) {
        if (plugin instanceof StrictAware) {
            StrictAware strictAware = (StrictAware)plugin;
            strictAware.setStrict(this.strict);
        }
    }

    private void setEventBusOnEventListenerPlugins(Object plugin) {
        if (plugin instanceof EventListener && this.bus != null) {
            Formatter formatter = (Formatter)plugin;
            formatter.setEventPublisher(this.bus);
        }
    }

    public List<String> getGlue() {
        return this.glue;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isDryRun() {
        return this.dryRun;
    }

    public List<String> getFeaturePaths() {
        return this.featurePaths;
    }

    public void addPlugin(Plugin plugin) {
        this.plugins.add(plugin);
        this.setMonochromeOnColorAwarePlugins(plugin);
        this.setStrictOnStrictAwarePlugins(plugin);
        this.setEventBusOnEventListenerPlugins(plugin);
    }

    public List<Pattern> getNameFilters() {
        return this.nameFilters;
    }

    public List<String> getTagFilters() {
        return this.tagFilters;
    }

    public Map<String, List<Long>> getLineFilters(ResourceLoader resourceLoader) {
        this.processRerunFiles(resourceLoader);
        return this.lineFilters;
    }

    private void processRerunFiles(ResourceLoader resourceLoader) {
        for (String featurePath : this.featurePaths) {
            if (!featurePath.startsWith("@")) continue;
            for (PathWithLines pathWithLines : CucumberFeature.loadRerunFile(resourceLoader, featurePath.substring(1))) {
                this.addLineFilters(this.lineFilters, pathWithLines.path, pathWithLines.lines);
            }
        }
    }

    public boolean isMonochrome() {
        return this.monochrome;
    }

    public SnippetType getSnippetType() {
        return this.snippetType;
    }

    public List<String> getJunitOptions() {
        return this.junitOptions;
    }

    void setEventBus(EventBus bus) {
        this.bus = bus;
    }

    static {
        QUOTE_MAPPER = new Mapper<String, String>(){

            @Override
            public String map(String o) {
                return '\"' + o + '\"';
            }
        };
        CODE_KEYWORD_MAPPER = new Mapper<String, String>(){

            @Override
            public String map(String keyword) {
                return keyword.replaceAll("[\\s',!]", "");
            }
        };
    }

    class ParsedOptionNames {
        private List<String> names = new ArrayList<String>();
        private boolean clobber = false;

        ParsedOptionNames() {
        }

        public void addName(String name, boolean isAddOption) {
            this.names.add(name);
            if (!isAddOption) {
                this.clobber = true;
            }
        }

        public void updateNameList(List<String> nameList) {
            if (!this.names.isEmpty()) {
                if (this.clobber) {
                    nameList.clear();
                }
                nameList.addAll(this.names);
            }
        }
    }

    class ParsedPluginData {
        ParsedOptionNames formatterNames;
        ParsedOptionNames stepDefinitionReporterNames;
        ParsedOptionNames summaryPrinterNames;

        ParsedPluginData() {
            this.formatterNames = new ParsedOptionNames();
            this.stepDefinitionReporterNames = new ParsedOptionNames();
            this.summaryPrinterNames = new ParsedOptionNames();
        }

        public void addPluginName(String name, boolean isAddPlugin) {
            if (PluginFactory.isStepDefinitionReporterName(name)) {
                this.stepDefinitionReporterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isSummaryPrinterName(name)) {
                this.summaryPrinterNames.addName(name, isAddPlugin);
            } else if (PluginFactory.isFormatterName(name)) {
                this.formatterNames.addName(name, isAddPlugin);
            } else {
                throw new CucumberException("Unrecognized plugin: " + name);
            }
        }

        public void updatePluginFormatterNames(List<String> pluginFormatterNames) {
            this.formatterNames.updateNameList(pluginFormatterNames);
        }

        public void updatePluginStepDefinitionReporterNames(List<String> pluginStepDefinitionReporterNames) {
            this.stepDefinitionReporterNames.updateNameList(pluginStepDefinitionReporterNames);
        }

        public void updatePluginSummaryPrinterNames(List<String> pluginSummaryPrinterNames) {
            this.summaryPrinterNames.updateNameList(pluginSummaryPrinterNames);
        }
    }
}

